/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.servlet;

import com.atlassian.http.mime.HostileExtensionDetector;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.util.IOUtil;
import com.atlassian.jira.util.JiraUrlCodec;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.servlet.CommonAttachment;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MimeSniffingKit {
    public static final String CONTENT_DISPOSITION_ATTACHMENT = "attachment";
    public static final String CONTENT_DISPOSITION_INLINE = "inline";
    private static final Logger log = LoggerFactory.getLogger(MimeSniffingKit.class);
    private final ApplicationProperties applicationProperties;
    private HostileExtensionDetector hostileExtensionDetector;

    public MimeSniffingKit(ApplicationProperties applicationProperties, HostileExtensionDetector hostileExtensionDetector) {
        this.applicationProperties = applicationProperties;
        this.hostileExtensionDetector = hostileExtensionDetector;
    }

    public void setAttachmentResponseHeaders(CommonAttachment attachment, String userAgent, HttpServletResponse httpServletResponse) {
        String filename = attachment.getFilename();
        String contentType = attachment.getContentType();
        this.setAttachmentResponseHeaders(httpServletResponse, filename, contentType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAttachmentResponseHeaders(HttpServletResponse httpServletResponse, String filename, String contentType) {
        InputStream inputStream = null;
        try {
            OpenAttachmentStrategy strategy = this.getOpenAttachmentStrategy(filename, contentType);
            strategy.setResponseHeaders(httpServletResponse);
        }
        finally {
            if (inputStream != null) {
                IOUtil.shutdownStream(inputStream);
            }
        }
    }

    public void setAttachmentResponseHeaders(String fileName, String mimeContentType, HttpServletResponse httpServletResponse) throws IOException {
        OpenAttachmentStrategy strategy = this.getOpenAttachmentStrategy(fileName, mimeContentType);
        strategy.setResponseHeaders(httpServletResponse);
    }

    private void setContentDispositionOnResponse(HttpServletResponse httpServletResponse, String filename, String contentDisposition) {
        String filenameEncoding = this.applicationProperties.getEncoding();
        httpServletResponse.setHeader("Content-Disposition", String.format("%s; filename*=%s''%s;", contentDisposition, filenameEncoding, JiraUrlCodec.encode((String)filename, (boolean)true)));
    }

    @Nonnull
    private OpenAttachmentStrategy getOpenAttachmentStrategy(String fileName, String mimeContentType) {
        String mimeSniffingPolicy = this.getMimeSniffingPolicy();
        boolean forceDownload = false;
        if (log.isDebugEnabled() && mimeSniffingPolicy.equalsIgnoreCase("insecure")) {
            log.debug("Mime sniffing policy is insecure, attachment will always be displayed inline");
        }
        if (!mimeSniffingPolicy.equalsIgnoreCase("insecure") && this.isExecutableContent(fileName, mimeContentType)) {
            forceDownload = true;
            if (log.isDebugEnabled()) {
                log.debug("Attachment \"" + fileName + "\" (" + mimeContentType + ") presents as executable content, forcing download.");
            }
        } else if (mimeSniffingPolicy.equalsIgnoreCase("secure")) {
            forceDownload = true;
        }
        return forceDownload ? new ForceDownload(fileName) : new ShowInline(fileName);
    }

    boolean isExecutableContent(String name, String contentType) {
        return this.hostileExtensionDetector.isExecutableFileExtension(name) || this.hostileExtensionDetector.isExecutableContentType(contentType);
    }

    private String getMimeSniffingPolicy() {
        String mimeSniffingPolicy = this.applicationProperties.getDefaultBackedString("jira.attachment.download.mime.sniffing.workaround");
        if (mimeSniffingPolicy == null) {
            mimeSniffingPolicy = "workaround";
            log.warn("Missing MIME sniffing policy application property jira.attachment.download.mime.sniffing.workaround ! Defaulting to workaround");
        }
        if (!("insecure".equalsIgnoreCase(mimeSniffingPolicy) || "secure".equalsIgnoreCase(mimeSniffingPolicy) || "workaround".equalsIgnoreCase(mimeSniffingPolicy))) {
            log.warn("MIME sniffing policy application property is invalid: " + mimeSniffingPolicy + " ! Defaulting to " + "workaround");
            mimeSniffingPolicy = "workaround";
        }
        return mimeSniffingPolicy;
    }

    private class ForceDownload
    extends OpenAttachmentStrategy {
        private ForceDownload(String filename) {
            super(filename);
        }

        @Override
        public void setResponseHeaders(HttpServletResponse httpServletResponse) {
            MimeSniffingKit.this.setContentDispositionOnResponse(httpServletResponse, this.filename, MimeSniffingKit.CONTENT_DISPOSITION_ATTACHMENT);
            httpServletResponse.setHeader("X-Download-Options", "noopen");
        }
    }

    private class ShowInline
    extends OpenAttachmentStrategy {
        public ShowInline(String fileName) {
            super(fileName);
        }

        @Override
        public void setResponseHeaders(HttpServletResponse httpServletResponse) {
            MimeSniffingKit.this.setContentDispositionOnResponse(httpServletResponse, this.filename, MimeSniffingKit.CONTENT_DISPOSITION_INLINE);
        }
    }

    private abstract class OpenAttachmentStrategy {
        final String filename;

        public OpenAttachmentStrategy(String filename) {
            this.filename = (String)Assertions.notNull((Object)filename);
        }

        abstract void setResponseHeaders(HttpServletResponse var1);
    }
}

