/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.servlet;

import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.icon.IconType;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.web.filters.johnson.ServiceUnavailableResponder;
import com.atlassian.jira.web.servlet.AbstractAvatarServlet;
import com.atlassian.jira.web.servlet.AvatarToStream;
import com.opensymphony.module.propertyset.PropertySet;
import java.io.IOException;
import java.net.URI;
import java.util.Optional;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewUserAvatarServlet
extends AbstractAvatarServlet {
    private static final Logger log = LoggerFactory.getLogger(ViewUserAvatarServlet.class);

    @Override
    protected void defaultDoGet(HttpServletRequest request, HttpServletResponse response, String ownerId, Long avatarId, Avatar.Size size) throws IOException, ServletException {
        AvatarService avatarService = ComponentAccessor.getAvatarService();
        ApplicationUser avatarUser = this.getUserManager().getUserByKey(ownerId);
        ApplicationUser remoteUser = this.getAuthenticationContext().getLoggedInUser();
        if (avatarUser != null && remoteUser != null && avatarService.isUsingExternalAvatar(remoteUser, avatarUser)) {
            this.redirectToExternalAvatar(response, ownerId, size);
            return;
        }
        super.defaultDoGet(request, response, ownerId, avatarId, size);
    }

    @Override
    protected AbstractAvatarServlet.PreprocessedInput preprocessInput(String ownerId, Long avatarId, Avatar.Size size, HttpServletResponse response) throws IOException {
        Optional userPropertyManagerOptional = ComponentAccessor.getComponentSafely(UserPropertyManager.class);
        if (!userPropertyManagerOptional.isPresent()) {
            ServiceUnavailableResponder.respondWithEmpty503(response);
            return AbstractAvatarServlet.PreprocessedInput.SKIP_PROCESSING;
        }
        Optional<AvatarManager> avatarManagerOptional = this.getAvatarManager();
        if (!avatarManagerOptional.isPresent()) {
            ServiceUnavailableResponder.respondWithEmpty503(response);
            return AbstractAvatarServlet.PreprocessedInput.SKIP_PROCESSING;
        }
        AvatarManager avatarManager = avatarManagerOptional.get();
        if (StringUtils.isBlank((CharSequence)ownerId) && avatarId == null) {
            response.sendError(404, "No avatar requested");
            return AbstractAvatarServlet.PreprocessedInput.SKIP_PROCESSING;
        }
        if (StringUtils.isNotBlank((CharSequence)ownerId)) {
            ApplicationUser user = this.getUserManager().getUserByKey(ownerId);
            if (user == null || !avatarManager.hasPermissionToView(this.getAuthenticationContext().getLoggedInUser(), user)) {
                return new AbstractAvatarServlet.PreprocessedInput(Long.parseLong(this.getApplicationProperties().getString("jira.avatar.user.anonymous.id")));
            }
            if (avatarId == null) {
                PropertySet userPropertySet = ((UserPropertyManager)userPropertyManagerOptional.get()).getPropertySet(user);
                avatarId = userPropertySet.exists("user.avatar.id") ? Long.valueOf(userPropertySet.getLong("user.avatar.id")) : Long.valueOf(Long.parseLong(this.getApplicationProperties().getString("jira.avatar.user.default.id")));
            }
        }
        if (this.isFeatureEnabled(JiraFeatureFlagRegistrar.RETURN_DEFAULT_AVATARS_FOR_BROKEN_AVATARS, false) && avatarId != null && !avatarManager.hasImage(avatarManager.getById(avatarId), size)) {
            Long defaultAvatarId = avatarManager.getDefaultAvatarId(IconType.USER_ICON_TYPE);
            log.debug("Unable to obtain avatar data for {}. Using default user avatar {}.", (Object)avatarId, (Object)defaultAvatarId);
            return new AbstractAvatarServlet.PreprocessedInput(defaultAvatarId, AvatarToStream.CachePolicies.DAYS_1);
        }
        return new AbstractAvatarServlet.PreprocessedInput(avatarId);
    }

    private void redirectToExternalAvatar(HttpServletResponse response, String ownerId, Avatar.Size size) throws IOException {
        Optional avatarServiceOptional = ComponentAccessor.getComponentSafely(AvatarService.class);
        if (!avatarServiceOptional.isPresent()) {
            response.sendError(404, "No AvatarService");
            return;
        }
        Optional<AvatarManager> avatarManagerOptional = this.getAvatarManager();
        if (!avatarManagerOptional.isPresent()) {
            response.sendError(404, "No AvatarManager");
            return;
        }
        ApplicationUser loggedInUser = this.getAuthenticationContext().getLoggedInUser();
        if (!avatarManagerOptional.get().hasPermissionToView(loggedInUser, this.getUserManager().getUserByKey(ownerId))) {
            response.sendError(404);
            return;
        }
        URI gravatarURL = ((AvatarService)avatarServiceOptional.get()).getAvatarURL(loggedInUser, this.getUserManager().getUserByKey(ownerId), size);
        response.sendRedirect(gravatarURL.toString());
    }

    @Override
    protected String getOwnerId(HttpServletRequest request) {
        String ownerId = super.getOwnerId(request);
        if (StringUtils.isBlank((CharSequence)ownerId)) {
            String username = StringUtils.trim((String)request.getParameter("username"));
            ApplicationUser user = this.getUserManager().getUserByName(username);
            if (user != null) {
                ownerId = user.getKey();
            }
        }
        return ownerId;
    }

    @Override
    protected String getOwnerIdParamName() {
        return "ownerId";
    }

    JiraAuthenticationContext getAuthenticationContext() {
        return ComponentAccessor.getJiraAuthenticationContext();
    }

    ApplicationProperties getApplicationProperties() {
        return ComponentAccessor.getApplicationProperties();
    }

    UserManager getUserManager() {
        return ComponentAccessor.getUserManager();
    }
}

