/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.session.cluster;

import com.atlassian.crowd.event.user.UserCredentialUpdatedEvent;
import com.atlassian.crowd.event.user.UsersDeletedEvent;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.event.user.anonymize.UserAnonymizationFinishedEvent;
import com.atlassian.jira.web.session.cluster.SessionInvalidationReplicatedEvent;

public class ReplicatedSessionInvalidationEventTransformer {
    final EventPublisher eventPublisher;

    public ReplicatedSessionInvalidationEventTransformer(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
        this.eventPublisher.register((Object)this);
    }

    @EventListener
    public void onUserCredentialUpdatedEvent(UserCredentialUpdatedEvent userCredentialUpdatedEvent) {
        this.eventPublisher.publish((Object)new SessionInvalidationReplicatedEvent(userCredentialUpdatedEvent.getUsername()));
    }

    @EventListener
    public void onUsersDeletedEvent(UsersDeletedEvent usersDeletedEvent) {
        for (String username : usersDeletedEvent.getUsernames()) {
            this.eventPublisher.publish((Object)new SessionInvalidationReplicatedEvent(username));
        }
    }

    @EventListener
    public void onUserAnonymizationFinishedEvent(UserAnonymizationFinishedEvent anonymizationEvent) {
        this.eventPublisher.publish((Object)new SessionInvalidationReplicatedEvent(anonymizationEvent.getOldUserName()));
    }
}

