/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webwork.parameters;

import com.atlassian.jira.webwork.parameters.AbstractParameterConverter;
import webwork.util.editor.PropertyEditorException;

public class FloatConverter
extends AbstractParameterConverter {
    @Override
    public Object convertParameter(String[] parameterValues, Class paramType) throws IllegalArgumentException {
        return this.convert(parameterValues[0], paramType);
    }

    Float convert(String parameterValue, Class paramType) {
        this.checkPrimitiveInput(parameterValue, paramType, "EMPTY_FLOAT");
        if (!paramType.isPrimitive() && this.isEmpty(parameterValue)) {
            return null;
        }
        return this.convertTo(parameterValue, paramType);
    }

    private Float convertTo(String parameterValue, Class paramType) {
        try {
            return Float.valueOf(parameterValue);
        }
        catch (NumberFormatException e) {
            throw new PropertyEditorException(paramType.isPrimitive() ? "BAD_FLOAT" : "BAD_FLOATOBJ", (Object)parameterValue);
        }
    }
}

