/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.cache.CachedReference;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.event.workflow.WorkflowDescriptorXmlUpdatedEvent;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.workflow.ImmutableWorkflowDescriptor;
import com.atlassian.jira.workflow.JiraWorkflowDTO;
import com.atlassian.jira.workflow.WorkflowDescriptorStore;
import com.opensymphony.workflow.FactoryException;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

@EventComponent
public class CachingWorkflowDescriptorStore
implements WorkflowDescriptorStore {
    private final Cache<String, Optional<ImmutableWorkflowDescriptor>> workflowCache;
    private final CachedReference<String[]> allNamesCache;
    private final WorkflowDescriptorStore delegate;

    public CachingWorkflowDescriptorStore(WorkflowDescriptorStore delegate, CacheManager cacheManager) {
        this.delegate = delegate;
        this.workflowCache = cacheManager.getCache(CachingWorkflowDescriptorStore.class.getName() + ".workflowCache", this::loadWorkflowDescriptor, new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build());
        this.allNamesCache = cacheManager.getCachedReference(CachingWorkflowDescriptorStore.class.getName() + ".allNamesCache", delegate::getWorkflowNames);
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.workflowCache.removeAll();
        this.allNamesCache.reset();
    }

    @EventListener
    public void onWorkflowDescriptorXmlUpdatedEvent(WorkflowDescriptorXmlUpdatedEvent event) {
        this.removeWorkflowFromCache(event.getWorkflowName());
    }

    @Override
    public ImmutableWorkflowDescriptor getWorkflow(@Nonnull String name) throws FactoryException {
        Assertions.notNull((String)"Workflow name", (Object)name);
        return ((Optional)this.workflowCache.get((Object)name)).orElse(null);
    }

    @Override
    public boolean removeWorkflow(@Nonnull String name) {
        boolean deleted;
        Assertions.notNull((String)"Workflow name", (Object)name);
        try {
            deleted = this.delegate.removeWorkflow(name);
        }
        finally {
            this.removeWorkflowFromCache(name);
        }
        return deleted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveWorkflow(@Nonnull String name, @Nonnull WorkflowDescriptor workflowDescriptor, boolean replace) throws DataAccessException {
        Assertions.notNull((String)"Workflow name", (Object)name);
        Assertions.notNull((String)"workflowDescriptor", (Object)workflowDescriptor);
        try {
            boolean bl = this.delegate.saveWorkflow(name, workflowDescriptor, replace);
            return bl;
        }
        finally {
            this.removeWorkflowFromCache(name);
        }
    }

    @Override
    public String[] getWorkflowNames() {
        String[] names = (String[])this.allNamesCache.get();
        return Arrays.copyOf(names, names.length);
    }

    @Override
    public List<JiraWorkflowDTO> getAllJiraWorkflowDTOs() {
        return this.delegate.getAllJiraWorkflowDTOs();
    }

    private void removeWorkflowFromCache(String name) {
        this.workflowCache.remove((Object)name);
        this.allNamesCache.reset();
    }

    @Nonnull
    private Optional<ImmutableWorkflowDescriptor> loadWorkflowDescriptor(@Nonnull String name) {
        try {
            return Optional.ofNullable(this.delegate.getWorkflow(name));
        }
        catch (FactoryException e) {
            throw new RuntimeException(e);
        }
    }
}

