/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow;

import com.atlassian.jira.issue.DocumentIssueImpl;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.workflow.IssueWorkflowManager;
import com.atlassian.jira.workflow.TransitionOptions;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.opensymphony.workflow.Workflow;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IssueWorkflowManagerImpl
implements IssueWorkflowManager {
    private static final Logger log = LoggerFactory.getLogger(IssueWorkflowManagerImpl.class);
    private final IssueManager issueManager;
    private final WorkflowManager workflowManager;
    private final JiraAuthenticationContext authenticationContext;
    private final PermissionManager permissionManager;

    public IssueWorkflowManagerImpl(IssueManager issueManager, WorkflowManager workflowManager, JiraAuthenticationContext authenticationContext, PermissionManager permissionManager) {
        this.issueManager = issueManager;
        this.workflowManager = workflowManager;
        this.authenticationContext = authenticationContext;
        this.permissionManager = permissionManager;
    }

    @Deprecated
    public Collection<ActionDescriptor> getAvailableActions(Issue issue) {
        return this.getAvailableActions(issue, TransitionOptions.defaults(), this.authenticationContext.getUser());
    }

    public Collection<ActionDescriptor> getAvailableActions(Issue issue, ApplicationUser user) {
        return this.getAvailableActions(issue, TransitionOptions.defaults(), user);
    }

    public Collection<ActionDescriptor> getAvailableActions(Issue issue, TransitionOptions transitionOptions, ApplicationUser user) {
        int[] actionIds = this.getAvailableActionIds(issue, transitionOptions, user);
        ArrayList<ActionDescriptor> availableActions = new ArrayList<ActionDescriptor>(actionIds.length);
        WorkflowDescriptor workflowDescriptor = this.workflowManager.getWorkflow(issue).getDescriptor();
        for (int actionId : actionIds) {
            ActionDescriptor action = workflowDescriptor.getAction(actionId);
            if (action == null) {
                log.error("State of issue [" + issue + "] has an action [id=" + actionId + "] which cannot be found in the workflow descriptor");
                continue;
            }
            availableActions.add(action);
        }
        return availableActions;
    }

    @Deprecated
    public List<ActionDescriptor> getSortedAvailableActions(Issue issue) {
        return this.getSortedAvailableActions(issue, TransitionOptions.defaults(), this.authenticationContext.getUser());
    }

    public List<ActionDescriptor> getSortedAvailableActions(Issue issue, ApplicationUser user) {
        return this.getSortedAvailableActions(issue, TransitionOptions.defaults(), user);
    }

    public List<ActionDescriptor> getSortedAvailableActions(Issue issue, TransitionOptions transitionOptions, ApplicationUser user) {
        ArrayList availableActions = Lists.newArrayList(this.getAvailableActions(issue, transitionOptions, user));
        availableActions.sort(Comparator.comparing(WorkflowUtil::getWorkflowTransitionOpsbarSequence));
        return availableActions;
    }

    @Deprecated
    public boolean isValidAction(Issue issue, int actionid) {
        return this.isValidAction(issue, actionid, TransitionOptions.defaults(), this.authenticationContext.getUser());
    }

    public boolean isValidAction(Issue issue, int actionId, ApplicationUser user) {
        return this.isValidAction(issue, actionId, TransitionOptions.defaults(), user);
    }

    public boolean isValidAction(Issue issue, int actionId, TransitionOptions transitionOptions, ApplicationUser user) {
        for (int id : this.getAvailableActionIds(issue, transitionOptions, user)) {
            if (id != actionId) continue;
            return true;
        }
        return false;
    }

    @VisibleForTesting
    int[] getAvailableActionIds(Issue issue, TransitionOptions transitionOptions, ApplicationUser user) {
        Issue originalIssue;
        Issue issueObject;
        if (!transitionOptions.skipPermissions() && !this.permissionManager.hasPermission(ProjectPermissions.TRANSITION_ISSUES, issue, user)) {
            return ArrayUtils.EMPTY_INT_ARRAY;
        }
        if (issue instanceof DocumentIssueImpl) {
            originalIssue = issueObject = this.issueManager.getIssueObject(issue.getId());
        } else {
            if (issue.getWorkflowId() == null) {
                log.error("!!! Issue " + issue.getKey() + " has no workflow ID !!! ");
                return ArrayUtils.EMPTY_INT_ARRAY;
            }
            issueObject = issue;
            originalIssue = this.issueManager.getIssueObject(issue.getId());
        }
        Workflow workflow = this.workflowManager.makeWorkflow(user);
        HashMap<String, String> inputs = new HashMap<String, String>();
        inputs.put("pkey", issueObject.getProjectObject().getKey());
        inputs.put("issue", (String)issueObject);
        inputs.put("originalissueobject", (String)originalIssue);
        inputs.putAll(transitionOptions.getWorkflowParams());
        return workflow.getAvailableActions(issueObject.getWorkflowId().longValue(), inputs);
    }
}

