/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.event.DraftWorkflowCreatedEvent;
import com.atlassian.jira.event.DraftWorkflowDeletedEvent;
import com.atlassian.jira.event.DraftWorkflowPublishedEvent;
import com.atlassian.jira.event.WorkflowCopiedEvent;
import com.atlassian.jira.event.WorkflowCreatedEvent;
import com.atlassian.jira.event.WorkflowDeletedEvent;
import com.atlassian.jira.event.WorkflowRenamedEvent;
import com.atlassian.jira.event.WorkflowUpdatedEvent;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.IssueTextFieldCharacterLengthValidator;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.issue.status.StatusImpl;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.transaction.Transaction;
import com.atlassian.jira.transaction.Txn;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.dbc.Null;
import com.atlassian.jira.web.bean.I18nBean;
import com.atlassian.jira.workflow.ConfigurableJiraWorkflow;
import com.atlassian.jira.workflow.DefaultJiraWorkflow;
import com.atlassian.jira.workflow.DraftWorkflowStore;
import com.atlassian.jira.workflow.JiraDraftWorkflow;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowException;
import com.atlassian.jira.workflow.WorkflowFunctionUtils;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowProgressAware;
import com.atlassian.jira.workflow.WorkflowScheme;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.atlassian.jira.workflow.WorkflowUtil;
import com.atlassian.jira.workflow.WorkflowsRepository;
import com.atlassian.jira.workflow.names.WorkflowCopyNameFactory;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.opensymphony.workflow.FactoryException;
import com.opensymphony.workflow.InvalidEntryStateException;
import com.opensymphony.workflow.InvalidInputException;
import com.opensymphony.workflow.InvalidRoleException;
import com.opensymphony.workflow.StoreException;
import com.opensymphony.workflow.Workflow;
import com.opensymphony.workflow.basic.BasicWorkflow;
import com.opensymphony.workflow.config.Configuration;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.ConditionDescriptor;
import com.opensymphony.workflow.loader.ConditionsDescriptor;
import com.opensymphony.workflow.loader.FunctionDescriptor;
import com.opensymphony.workflow.loader.StepDescriptor;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import com.opensymphony.workflow.spi.SimpleStep;
import com.opensymphony.workflow.spi.Step;
import com.opensymphony.workflow.spi.WorkflowEntry;
import com.opensymphony.workflow.spi.WorkflowStore;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.util.UtilDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import webwork.action.ActionContext;

public class OSWorkflowManager
implements WorkflowManager {
    private static final Logger log = LoggerFactory.getLogger(OSWorkflowManager.class);
    private volatile Configuration configuration;
    private final DraftWorkflowStore draftWorkflowStore;
    private final EventPublisher eventPublisher;
    private WorkflowsRepository workflowsRepository;
    private WorkflowCopyNameFactory workflowCopyNameFactory;
    private final JiraAuthenticationContext context;
    private final IssueTextFieldCharacterLengthValidator textFieldCharacterLengthValidator;

    public OSWorkflowManager(Configuration configuration, DraftWorkflowStore draftWorkflowStore, EventPublisher eventPublisher, WorkflowsRepository workflowsRepository, WorkflowCopyNameFactory workflowCopyNameFactory, JiraAuthenticationContext context, IssueTextFieldCharacterLengthValidator textFieldCharacterLengthValidator) {
        this.workflowsRepository = workflowsRepository;
        this.workflowCopyNameFactory = workflowCopyNameFactory;
        this.context = context;
        this.setConfiguration(configuration);
        this.draftWorkflowStore = draftWorkflowStore;
        this.eventPublisher = eventPublisher;
        this.textFieldCharacterLengthValidator = textFieldCharacterLengthValidator;
    }

    public Collection<JiraWorkflow> getWorkflows() {
        ArrayList workflows = Lists.newArrayList();
        try {
            String[] workflowNames = this.getConfiguration().getWorkflowNames();
            workflows = Lists.newArrayListWithCapacity((int)workflowNames.length);
            for (String workflowName : workflowNames) {
                workflows.add(this.getWorkflow(workflowName));
            }
        }
        catch (FactoryException e) {
            log.error("Could not get workflow names: " + (Object)((Object)e), (Throwable)e);
        }
        Collections.sort(workflows);
        return workflows;
    }

    public List<JiraWorkflow> getWorkflowsIncludingDrafts() {
        Collection<JiraWorkflow> workflows = this.getWorkflows();
        ArrayList ret = Lists.newArrayListWithCapacity((int)workflows.size());
        for (JiraWorkflow jiraWorkflow : workflows) {
            ret.add(jiraWorkflow);
            JiraWorkflow draftWorkflow = this.getDraftWorkflow(jiraWorkflow.getName());
            if (draftWorkflow == null) continue;
            ret.add(draftWorkflow);
        }
        return ret;
    }

    protected String getWorkflowName(Long projectId, String issueType) {
        Project project = this.getProjectManager().getProjectObj(projectId);
        return this.getWorkflowSchemeManager().getWorkflowName(project, issueType);
    }

    private ProjectManager getProjectManager() {
        return ComponentAccessor.getProjectManager();
    }

    public Collection<JiraWorkflow> getActiveWorkflows() throws WorkflowException {
        return this.getSchemeActiveWorkflows();
    }

    public boolean isActive(JiraWorkflow workflow) throws WorkflowException {
        return this.getSchemeActiveWorkflows().contains(workflow);
    }

    public boolean isSystemWorkflow(JiraWorkflow workflow) {
        return !this.getConfiguration().isModifiable(workflow.getName());
    }

    private Collection<JiraWorkflow> getSchemeActiveWorkflows() throws WorkflowException {
        try {
            Collection names = this.getWorkflowSchemeManager().getActiveWorkflowNames();
            HashSet<JiraWorkflow> workflows = new HashSet<JiraWorkflow>();
            for (String name : names) {
                workflows.add(this.getWorkflow(name));
            }
            return workflows;
        }
        catch (GenericEntityException e) {
            throw new WorkflowException((Throwable)e);
        }
    }

    public JiraWorkflow getWorkflow(String name) {
        try {
            WorkflowDescriptor workflowDescriptor = this.getConfiguration().getWorkflow(name);
            if ("jira".equals(name)) {
                return new DefaultJiraWorkflow(workflowDescriptor, this, this.context);
            }
            return new ConfigurableJiraWorkflow(name, workflowDescriptor, this);
        }
        catch (FactoryException e) {
            log.debug("Could not get workflow called: " + name + ": " + (Object)((Object)e), (Throwable)e);
            return null;
        }
    }

    public JiraWorkflow getWorkflowClone(String name) {
        try {
            WorkflowDescriptor workflowDescriptor = this.getConfiguration().getWorkflow(name);
            if ("jira".equals(name)) {
                return new DefaultJiraWorkflow(workflowDescriptor, this, this.context);
            }
            WorkflowDescriptor mutableDescriptor = this.cloneDescriptor(workflowDescriptor);
            return new ConfigurableJiraWorkflow(name, mutableDescriptor, this);
        }
        catch (FactoryException e) {
            log.error("Could not get workflow called: " + name + ": " + (Object)((Object)e), (Throwable)e);
            return null;
        }
    }

    WorkflowDescriptor cloneDescriptor(WorkflowDescriptor workflowDescriptor) throws FactoryException {
        return WorkflowUtil.convertXMLtoWorkflowDescriptor((String)WorkflowUtil.convertDescriptorToXML((WorkflowDescriptor)workflowDescriptor));
    }

    public JiraWorkflow getDraftWorkflow(String parentWorkflowName) throws IllegalArgumentException {
        JiraWorkflow parentWorkflow = this.getWorkflow(parentWorkflowName);
        if (parentWorkflow == null) {
            throw new IllegalArgumentException("Draft workflow could not be retrieved, since the parent workflow with name '" + parentWorkflowName + "' does not exist.");
        }
        return this.draftWorkflowStore.getDraftWorkflow(parentWorkflowName);
    }

    public JiraWorkflow createDraftWorkflow(String username, String parentWorkflowName) {
        if (username == null) {
            throw new IllegalArgumentException("You can not create a draft workflow with a null username.");
        }
        ApplicationUser user = this.getUserManager().getUserByName(username);
        return this.createDraftWorkflow(user, parentWorkflowName);
    }

    public JiraWorkflow createDraftWorkflow(ApplicationUser user, String parentWorkflowName) {
        if (user == null) {
            throw new IllegalArgumentException("You can not create a draft workflow with a null user.");
        }
        JiraWorkflow parentWorkflow = this.getWorkflow(parentWorkflowName);
        if (parentWorkflow == null) {
            throw new IllegalArgumentException("You can not create a draft workflow from a parent that does not exist.");
        }
        if (!parentWorkflow.isActive()) {
            throw new IllegalStateException("You can not create a draft workflow from a parent workflow that is not active.");
        }
        JiraWorkflow draftWorkflow = this.draftWorkflowStore.createDraftWorkflow(user, parentWorkflow);
        this.eventPublisher.publish((Object)new DraftWorkflowCreatedEvent(draftWorkflow));
        return draftWorkflow;
    }

    public boolean deleteDraftWorkflow(String parentWorkflowName) throws IllegalArgumentException {
        if (StringUtils.isBlank((CharSequence)parentWorkflowName)) {
            throw new IllegalArgumentException("Can not delete a draft workflow for a parent workflow name of null.");
        }
        JiraWorkflow draftWorkflow = this.getDraftWorkflow(parentWorkflowName);
        boolean deleted = this.draftWorkflowStore.deleteDraftWorkflow(parentWorkflowName);
        if (deleted) {
            this.eventPublisher.publish((Object)new DraftWorkflowDeletedEvent(draftWorkflow));
        }
        return deleted;
    }

    public boolean workflowExists(String name) throws WorkflowException {
        return this.workflowsRepository.contains(name);
    }

    public JiraWorkflow getWorkflow(Issue issue) throws WorkflowException {
        GenericValue project = issue.getProject();
        if (project == null) {
            throw new IllegalArgumentException("Project for issue with id '" + issue.getId() + "' is null.");
        }
        IssueType issueType = issue.getIssueTypeObject();
        if (issueType == null) {
            throw new IllegalArgumentException("Issue Type for issue with id '" + issue.getId() + "' is null.");
        }
        return this.getWorkflow(project.getLong("id"), issueType.getId());
    }

    public JiraWorkflow getWorkflow(Long projectId, String issueTypeId) throws WorkflowException {
        return this.getWorkflow(this.getWorkflowName(projectId, issueTypeId));
    }

    public JiraWorkflow getWorkflowFromScheme(GenericValue scheme, String issueTypeId) {
        return this.getWorkflow(this.getWorkflowSchemeManager().getWorkflowName(scheme, issueTypeId));
    }

    public JiraWorkflow getWorkflowFromScheme(WorkflowScheme scheme, String issueTypeId) {
        return this.getWorkflow(scheme.getActualWorkflow(issueTypeId));
    }

    public Collection<JiraWorkflow> getWorkflowsFromScheme(GenericValue scheme) throws WorkflowException {
        if (scheme != null) {
            try {
                List schemeEntities = this.getWorkflowSchemeManager().getEntities(scheme);
                if (schemeEntities != null) {
                    ArrayList<JiraWorkflow> result = new ArrayList<JiraWorkflow>(schemeEntities.size());
                    for (GenericValue schemeEntity : schemeEntities) {
                        result.add(this.getWorkflow(schemeEntity.getString("workflow")));
                    }
                    return result;
                }
            }
            catch (GenericEntityException e) {
                throw new WorkflowException((Throwable)e);
            }
        }
        return CollectionBuilder.newBuilder((Object[])new JiraWorkflow[]{this.getWorkflow("jira")}).asMutableList();
    }

    public Iterable<JiraWorkflow> getWorkflowsFromScheme(Scheme workflowScheme) throws WorkflowException {
        try {
            if (workflowScheme == null) {
                return this.getWorkflowsFromScheme((GenericValue)null);
            }
            return this.getWorkflowsFromScheme(this.getWorkflowSchemeManager().getScheme(workflowScheme.getId()));
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    public void copyAndDeleteDraftWorkflows(ApplicationUser user, Set<JiraWorkflow> workflows) {
        this.copyAndDeleteDraftsForInactiveWorkflowsIn(user, workflows);
    }

    public void copyAndDeleteDraftsForInactiveWorkflowsIn(ApplicationUser user, Iterable<JiraWorkflow> workflows) {
        if (workflows == null || Iterables.isEmpty(workflows)) {
            return;
        }
        for (JiraWorkflow workflow : workflows) {
            String parentWorkflowName = workflow.getName();
            JiraWorkflow draftWorkflow = this.getDraftWorkflow(parentWorkflowName);
            if (workflow.isActive() || draftWorkflow == null) continue;
            String username = user == null ? null : user.getName();
            StringBuilder builder = new StringBuilder();
            String parentDescription = StringUtils.stripToNull((String)draftWorkflow.getDescription());
            if (parentDescription != null) {
                builder.append(parentDescription).append(" ");
            }
            builder.append(this.getI18nBean(user).getText("admin.workflows.manager.draft.auto.generated", parentWorkflowName));
            this.copyWorkflow(username, this.getClonedWorkflowName(parentWorkflowName, user), builder.toString(), draftWorkflow);
            this.deleteDraftWorkflow(parentWorkflowName);
        }
    }

    @Nonnull
    public String getNextStatusIdForAction(@Nonnull Issue issue, int actionId) {
        JiraWorkflow workflow = this.getWorkflow(issue);
        if (workflow == null) {
            throw new IllegalStateException("There is no workflow for the issue with key " + issue.getKey());
        }
        ActionDescriptor actionDescriptor = this.getActionDescriptor(workflow, actionId);
        return this.getNextStatusIdForAction(issue, workflow, actionDescriptor);
    }

    @Nonnull
    public String getNextStatusIdForAction(@Nonnull Issue issue, @Nonnull JiraWorkflow workflow, @Nonnull ActionDescriptor actionDescriptor) {
        int stepId = actionDescriptor.getUnconditionalResult().getStep();
        if (stepId == -1) {
            return issue.getStatusObject().getId();
        }
        StepDescriptor step = workflow.getDescriptor().getStep(stepId);
        return workflow.getLinkedStatusId(step);
    }

    @Nonnull
    public Optional<String> getInitialStatusIdForIssue(@Nonnull Issue issue) {
        JiraWorkflow workflow = this.getWorkflow(issue);
        Optional<ActionDescriptor> initialAction = workflow.getAllActions().stream().filter(arg_0 -> ((JiraWorkflow)workflow).isInitialAction(arg_0)).findFirst();
        return initialAction.map(actionDescriptor -> this.getNextStatusIdForAction(issue, workflow, (ActionDescriptor)actionDescriptor));
    }

    @Nonnull
    public ActionDescriptor getActionDescriptor(@Nonnull Issue issue, int actionId) {
        JiraWorkflow workflow = this.getWorkflow(issue);
        if (workflow == null) {
            throw new IllegalStateException("There is no workflow for the issue with key " + issue.getKey());
        }
        return this.getActionDescriptor(workflow, actionId);
    }

    private ActionDescriptor getActionDescriptor(JiraWorkflow workflow, int actionId) {
        ActionDescriptor action = workflow.getDescriptor().getAction(actionId);
        if (action == null) {
            throw new IllegalStateException("There is no action descriptor for an action with id " + actionId);
        }
        return action;
    }

    private void createActualWorkflow(ApplicationUser user, JiraWorkflow workflow) throws WorkflowException {
        this.addAuditInfo(user, workflow);
        this.saveWorkflowWithoutAudit(workflow);
    }

    public void createWorkflow(String username, JiraWorkflow workflow) throws WorkflowException {
        ApplicationUser user = this.getUserManager().getUserByName(username);
        this.createWorkflow(user, workflow);
    }

    public void createWorkflow(ApplicationUser user, JiraWorkflow workflow) throws WorkflowException {
        this.createActualWorkflow(user, workflow);
        this.eventPublisher.publish((Object)new WorkflowCreatedEvent(workflow));
    }

    private void addAuditInfo(ApplicationUser user, JiraWorkflow workflow) {
        if (workflow == null) {
            return;
        }
        WorkflowDescriptor descriptor = workflow.getDescriptor();
        log.info("User '" + user + "' updated workflow '" + workflow.getName() + "' at '" + new Date() + "'");
        if (user != null) {
            descriptor.getMetaAttributes().put("jira.update.author.key", user.getKey());
        } else {
            descriptor.getMetaAttributes().put("jira.update.author.key", "");
        }
        descriptor.getMetaAttributes().put("jira.updated.date", Long.toString(System.currentTimeMillis()));
    }

    public void saveWorkflowWithoutAudit(JiraWorkflow workflow) throws WorkflowException {
        if (workflow.isDraftWorkflow()) {
            this.draftWorkflowStore.updateDraftWorkflowWithoutAudit(workflow.getName(), workflow);
        }
        try {
            this.getConfiguration().saveWorkflow(workflow.getName(), workflow.getDescriptor(), true);
            workflow.reset();
        }
        catch (FactoryException e) {
            throw new WorkflowException((Throwable)e);
        }
    }

    protected WorkflowSchemeManager getWorkflowSchemeManager() {
        return ComponentAccessor.getWorkflowSchemeManager();
    }

    public void deleteWorkflow(JiraWorkflow workflow) throws WorkflowException {
        if (!Iterables.isEmpty((Iterable)this.getWorkflowSchemeManager().getSchemesForWorkflowIncludingDrafts(workflow))) {
            throw new WorkflowException("The workflow is assigned to workflow schemes");
        }
        try {
            this.deleteDraftWorkflow(workflow.getName());
            this.getConfiguration().removeWorkflow(workflow.getName());
            this.eventPublisher.publish((Object)new WorkflowDeletedEvent(workflow));
        }
        catch (FactoryException e) {
            throw new WorkflowException("Error deleting workflow: " + (Object)((Object)e), (Throwable)e);
        }
    }

    public JiraWorkflow getWorkflow(GenericValue issue) throws WorkflowException {
        String workflowName = this.getWorkflowName(issue.getLong("project"), issue.getString("type"));
        return this.getWorkflow(workflowName);
    }

    public void migrateIssueToWorkflow(GenericValue issue, JiraWorkflow newWorkflow, GenericValue newStatus) throws WorkflowException {
        if (this.migrateIssueToWorkflowNoReindex(issue, newWorkflow, newStatus)) {
            try {
                this.getIssueIndexManager().reIndex(issue);
            }
            catch (IndexException e) {
                log.error("Error indexing issue during workflow migration: " + (Object)((Object)e), (Throwable)e);
            }
        }
    }

    public boolean migrateIssueToWorkflowNoReindex(GenericValue issue, JiraWorkflow newWorkflow, GenericValue newStatus) throws WorkflowException {
        try {
            WorkflowStore store = this.getStore();
            long wfid = issue.getLong("workflowId");
            List currentSteps = store.findCurrentSteps(wfid);
            SimpleStep currentStep = null;
            if (!currentSteps.isEmpty()) {
                currentStep = (SimpleStep)currentSteps.get(0);
            }
            WorkflowEntry newEntry = store.createEntry(newWorkflow.getName());
            store.setEntryState(newEntry.getId(), 1);
            store.setEntryState(wfid, 3);
            StepDescriptor stepInNewWorkflow = newWorkflow.getLinkedStep(newStatus);
            if (stepInNewWorkflow == null) {
                throw new RuntimeException("No step associated with status " + (newStatus == null ? "null" : newStatus.getString("name")) + " in new workflow " + newWorkflow.getName());
            }
            if (currentStep != null) {
                store.createCurrentStep(newEntry.getId(), stepInNewWorkflow.getId(), currentStep.getOwner(), currentStep.getStartDate(), currentStep.getDueDate(), currentStep.getStatus(), null);
                store.moveToHistory((Step)currentStep);
            } else {
                Timestamp startDate = issue.getTimestamp("created");
                store.createCurrentStep(newEntry.getId(), stepInNewWorkflow.getId(), null, (Date)startDate, null, newStatus.getString("id"), null);
            }
            boolean result = this.updateIssueStatusAndUpdatedDate(issue, newStatus);
            issue.set("workflowId", (Object)newEntry.getId());
            issue.store();
            return result;
        }
        catch (StoreException e) {
            throw new WorkflowException((Throwable)e);
        }
        catch (GenericEntityException e) {
            throw new WorkflowException((Throwable)e);
        }
    }

    public void overwriteActiveWorkflow(String username, String workflowName) {
        this.overwriteActiveWorkflow(this.getUserManager().getUserByName(username), workflowName);
    }

    public void overwriteActiveWorkflow(ApplicationUser user, String workflowName) {
        boolean saved;
        JiraWorkflow draftWorkflow = this.draftWorkflowStore.getDraftWorkflow(workflowName);
        if (draftWorkflow == null) {
            throw new WorkflowException("No draft workflow named '" + workflowName + "'");
        }
        JiraWorkflow originalWorkflow = this.getWorkflow(workflowName);
        try {
            this.addAuditInfo(user, draftWorkflow);
            saved = this.getConfiguration().saveWorkflow(workflowName, draftWorkflow.getDescriptor(), true);
            this.eventPublisher.publish((Object)new DraftWorkflowPublishedEvent(draftWorkflow, originalWorkflow));
        }
        catch (FactoryException e) {
            throw new WorkflowException((Throwable)e);
        }
        if (!saved) {
            throw new WorkflowException("Workflow '" + workflowName + "' could not be overwritten!");
        }
        this.draftWorkflowStore.deleteDraftWorkflow(workflowName);
    }

    protected boolean updateIssueStatusAndUpdatedDate(GenericValue issue, GenericValue newStatus) {
        if (!issue.getString("status").equals(newStatus.getString("id"))) {
            issue.set("updated", (Object)UtilDateTime.nowTimestamp());
            issue.set("status", (Object)newStatus.getString("id"));
            return true;
        }
        return false;
    }

    public void updateWorkflow(String username, JiraWorkflow workflow) {
        if (username == null) {
            throw new IllegalArgumentException("Can not update a workflow with a null username.");
        }
        this.updateWorkflow(this.getUserManager().getUserByName(username), workflow);
    }

    public void updateWorkflow(ApplicationUser user, JiraWorkflow workflow) {
        JiraWorkflow originalWorkflow;
        if (user == null) {
            throw new IllegalArgumentException("Can not update a workflow with a null user.");
        }
        if (workflow == null || workflow.getDescriptor() == null) {
            throw new IllegalArgumentException("Can not update a workflow with a null workflow/descriptor.");
        }
        if (workflow.isDraftWorkflow()) {
            JiraWorkflow parentWorkflow = this.getWorkflow(workflow.getName());
            if (parentWorkflow == null) {
                throw new IllegalStateException("You can not update a draft workflow for a parent that does not exist.");
            }
            originalWorkflow = this.getDraftWorkflow(workflow.getName());
            this.draftWorkflowStore.updateDraftWorkflow(user, workflow.getName(), workflow);
        } else {
            originalWorkflow = this.getWorkflow(workflow.getName());
            if (workflow.isActive()) {
                throw new WorkflowException("Cannot save an active workflow.");
            }
            if (workflow.isSystemWorkflow()) {
                throw new WorkflowException("Cannot change the system workflow.");
            }
            this.createActualWorkflow(user, workflow);
        }
        this.eventPublisher.publish((Object)new WorkflowUpdatedEvent(workflow, originalWorkflow));
    }

    public JiraWorkflow copyWorkflow(String username, String clonedWorkflowName, String clonedWorkflowDescription, JiraWorkflow workflowToClone) {
        return this.copyWorkflow(this.getUserManager().getUserByName(username), clonedWorkflowName, clonedWorkflowDescription, workflowToClone);
    }

    public JiraWorkflow copyWorkflow(ApplicationUser user, String clonedWorkflowName, String clonedWorkflowDescription, JiraWorkflow workflowToClone) {
        WorkflowDescriptor workflowDescriptor;
        try {
            workflowDescriptor = this.cloneDescriptor(workflowToClone.getDescriptor());
        }
        catch (FactoryException e) {
            throw new WorkflowException("Unexpected exception copying a workflowDescriptor for workflow '" + clonedWorkflowName + "'!", (Throwable)e);
        }
        ConfigurableJiraWorkflow newWorkflow = new ConfigurableJiraWorkflow(clonedWorkflowName, workflowDescriptor, this);
        if (StringUtils.isNotEmpty((CharSequence)clonedWorkflowDescription)) {
            newWorkflow.setDescription(clonedWorkflowDescription);
        } else {
            newWorkflow.setDescription("");
        }
        this.createActualWorkflow(user, newWorkflow);
        this.eventPublisher.publish((Object)new WorkflowCopiedEvent(workflowToClone, (JiraWorkflow)newWorkflow));
        return newWorkflow;
    }

    public void updateWorkflowNameAndDescription(String username, JiraWorkflow currentWorkflow, String newName, String newDescription) {
        this.updateWorkflowNameAndDescription(this.getUserManager().getUserByName(username), currentWorkflow, newName, newDescription);
    }

    public void updateWorkflowNameAndDescription(ApplicationUser user, JiraWorkflow currentWorkflow, String newName, String newDescription) {
        Null.not("currentWorkflow", currentWorkflow);
        String currentWorkflowName = currentWorkflow.getName();
        JiraWorkflow workflow = currentWorkflow;
        if (!currentWorkflow.isDraftWorkflow()) {
            workflow = this.getWorkflowClone(currentWorkflowName);
        }
        if (newDescription != null && !newDescription.equals(workflow.getDescription())) {
            WorkflowDescriptor descriptor = workflow.getDescriptor();
            descriptor.getMetaAttributes().put("jira.description", newDescription);
            this.updateWorkflow(user, workflow);
        }
        if (!currentWorkflowName.equals(newName) && !currentWorkflow.isDraftWorkflow()) {
            try {
                this.getConfiguration().removeWorkflow(currentWorkflowName);
                this.getConfiguration().saveWorkflow(newName, workflow.getDescriptor(), true);
                this.getWorkflowSchemeManager().updateSchemesForRenamedWorkflow(currentWorkflowName, newName);
                JiraWorkflow draftWorkflow = this.draftWorkflowStore.getDraftWorkflow(currentWorkflowName);
                if (draftWorkflow != null) {
                    log.warn("Inactive workflow '" + newName + "' has a draft workflow. Please remove this draft!");
                    JiraDraftWorkflow newWorkflow = new JiraDraftWorkflow(newName, this, draftWorkflow.getDescriptor());
                    this.draftWorkflowStore.createDraftWorkflow(user, newWorkflow);
                    this.draftWorkflowStore.deleteDraftWorkflow(currentWorkflowName);
                }
                this.eventPublisher.publish((Object)new WorkflowRenamedEvent(workflow, currentWorkflowName, newName));
            }
            catch (FactoryException e) {
                throw new WorkflowException("Error renaming workflow '" + currentWorkflow + "' to '" + newName + "' " + (Object)((Object)e), (Throwable)e);
            }
        }
    }

    I18nHelper getI18nBean(ApplicationUser user) {
        return new I18nBean(user);
    }

    String getClonedWorkflowName(String parentWorkflowName, ApplicationUser user) {
        return this.workflowCopyNameFactory.createFrom(parentWorkflowName, this.getI18nBean(user).getLocale());
    }

    void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public JiraWorkflow getDefaultWorkflow() throws WorkflowException {
        return this.getWorkflow("jira");
    }

    public GenericValue createIssue(String remoteUserName, Map<String, Object> fields) throws WorkflowException {
        try {
            Issue issue = (Issue)fields.get("issue");
            Long projectId = issue.getProjectId();
            String issueTypeId = issue.getIssueTypeId();
            JiraWorkflow jiraWorkflow = this.getWorkflow(projectId, issueTypeId);
            if (jiraWorkflow == null) {
                throw new IllegalArgumentException("Cannot find workflow for project with id '" + projectId + "' and issue type with id '" + issueTypeId + "'.");
            }
            Workflow workflow = this.makeWorkflowWithUserName(remoteUserName);
            WorkflowDescriptor workflowDescriptor = jiraWorkflow.getDescriptor();
            List initialActions = workflowDescriptor.getInitialActions();
            if (initialActions == null || initialActions.isEmpty()) {
                throw new WorkflowException("No initial actions exist for workflow with name '" + jiraWorkflow.getName() + ".");
            }
            ActionDescriptor actionDescriptor = (ActionDescriptor)initialActions.get(0);
            long wfId = workflow.initialize(jiraWorkflow.getName(), actionDescriptor.getId(), fields);
            GenericValue issueGV = this.getIssueManager().getIssueByWorkflow(Long.valueOf(wfId));
            if (issueGV == null) {
                throw new WorkflowException("Issue workflow initialization error: unable to find Issue created with workflowId '" + wfId + "'. Did the IssueCreateFunction run successfully on workflow.initialize() ?");
            }
            return issueGV;
        }
        catch (InvalidRoleException e) {
            throw new WorkflowException(e.getMessage(), (Throwable)e);
        }
        catch (InvalidInputException e) {
            throw new WorkflowException(e.getMessage(), (Throwable)e);
        }
        catch (GenericEntityException e) {
            throw new WorkflowException(e.getMessage(), (Throwable)e);
        }
        catch (InvalidEntryStateException e) {
            throw new WorkflowException(e.getMessage(), (Throwable)e);
        }
        catch (com.opensymphony.workflow.WorkflowException e) {
            throw new WorkflowException(e.getMessage(), (Throwable)e);
        }
        catch (ClassCastException e) {
            String message = "Error occurred while creating issue. This could be due to a plugin being incompatible with this version of JIRA. For more details please consult the logs, and see: http://confluence.atlassian.com/x/3McB";
            throw new WorkflowException(message, (Throwable)e);
        }
        catch (Exception e) {
            throw new WorkflowException(e.getMessage(), (Throwable)e);
        }
    }

    public void removeWorkflowEntries(GenericValue issue) {
        this.getOfBizDelegator().removeByAnd("OSWorkflowEntry", (Map)FieldMap.build((String)"id", (Object)issue.getLong("workflowId")));
        this.getOfBizDelegator().removeByAnd("OSCurrentStep", (Map)FieldMap.build((String)"entryId", (Object)issue.getLong("workflowId")));
        this.getOfBizDelegator().removeByAnd("OSHistoryStep", (Map)FieldMap.build((String)"entryId", (Object)issue.getLong("workflowId")));
    }

    private OfBizDelegator getOfBizDelegator() {
        return ComponentAccessor.getOfBizDelegator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doWorkflowAction(WorkflowProgressAware from) {
        this.disableIndexingForThisThread();
        Transaction txn = Txn.begin();
        try {
            this.doWorkflowActionInsideTxn(txn, from);
        }
        finally {
            try {
                this.enableIndexingForThisThread();
            }
            catch (IndexException e) {
                throw new WorkflowException(e.getMessage(), (Throwable)e);
            }
            txn.finallyRollbackIfNotCommitted();
        }
    }

    /*
     * Exception decompiling
     */
    private void doWorkflowActionInsideTxn(Transaction txn, WorkflowProgressAware from) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void validateIssueFieldsLength(WorkflowProgressAware from, MutableIssue issue) throws InvalidInputException {
        IssueTextFieldCharacterLengthValidator.ValidationResult validationResult = this.textFieldCharacterLengthValidator.validateModifiedFields(issue);
        if (!validationResult.isValid()) {
            I18nHelper i18n = this.getI18nBean(from.getRemoteUser());
            HashMap invalidFields = Maps.newHashMapWithExpectedSize((int)validationResult.getInvalidFieldIds().size());
            for (String fieldId : validationResult.getInvalidFieldIds()) {
                invalidFields.put(fieldId, i18n.getText("field.error.text.toolong", (Object)validationResult.getMaximumNumberOfCharacters()));
            }
            throw new InvalidInputException((Object)invalidFields);
        }
    }

    private IssueIndexManager getIssueIndexManager() {
        return (IssueIndexManager)ComponentAccessor.getComponent(IssueIndexManager.class);
    }

    private void disableIndexingForThisThread() {
        this.getIssueIndexManager().hold();
    }

    private void enableIndexingForThisThread() throws IndexException {
        this.getIssueIndexManager().release();
    }

    private Workflow getWorkflowObject(WorkflowProgressAware from) {
        String userkey = WorkflowFunctionUtils.getCallerKey(null, (Map)from.getAdditionalInputs());
        if (userkey == null && ActionContext.getPrincipal() != null) {
            ApplicationUser principal = this.getUserManager().getUserByName(ActionContext.getPrincipal().getName());
            String string = userkey = principal == null ? null : principal.getKey();
        }
        if (userkey == null) {
            userkey = ApplicationUsers.getKeyFor(from.getRemoteApplicationUser());
        }
        return this.makeWorkflow(ApplicationUsers.byKey(userkey));
    }

    private UserManager getUserManager() {
        return ComponentAccessor.getUserManager();
    }

    public WorkflowStore getStore() throws StoreException {
        return this.getConfiguration().getWorkflowStore();
    }

    public ActionDescriptor getActionDescriptor(WorkflowProgressAware workflowProgressAware) throws Exception {
        JiraWorkflow workflow = this.getWorkflow(workflowProgressAware.getIssue().getGenericValue());
        return workflow.getDescriptor().getAction(workflowProgressAware.getAction());
    }

    public void migrateIssueToWorkflow(MutableIssue issue, JiraWorkflow newWorkflow, Status status) throws WorkflowException {
        GenericValue issueGV = issue.getGenericValue();
        this.migrateIssueToWorkflow(issueGV, newWorkflow, status != null ? ((StatusImpl)status).getGenericValue() : null);
        issue.setWorkflowId(issueGV.getLong("workflowId"));
        issue.setStatusId(issueGV.getString("status"));
    }

    public Workflow makeWorkflow(String userName) {
        return this.makeWorkflowWithUserName(userName);
    }

    public Workflow makeWorkflowWithUserName(String userName) {
        ApplicationUser appUser = this.getUserManager().getUserByName(userName);
        return this.makeWorkflowWithUserKey(appUser != null ? appUser.getKey() : null);
    }

    public Workflow makeWorkflowWithUserKey(String userKey) {
        BasicWorkflow workflow = new BasicWorkflow(userKey);
        workflow.setConfiguration(this.getConfiguration());
        return workflow;
    }

    public Workflow makeWorkflow(ApplicationUser user) {
        if (user == null) {
            return this.makeWorkflowWithUserKey(null);
        }
        return this.makeWorkflowWithUserName(user.getName());
    }

    public boolean isEditable(Issue issue) {
        if (issue == null || issue.getStatus() == null || issue.getStatus().getId() == null) {
            return false;
        }
        return this.isEditable(issue, issue.getStatus().getId());
    }

    public boolean isEditable(@Nonnull Issue issue, @Nonnull String nextStatusId) {
        if (issue.getProjectObject() == null || issue.getIssueType() == null) {
            return false;
        }
        JiraWorkflow workflow = this.getWorkflow(issue);
        if (workflow != null) {
            return this.isEditableInWorkflow(issue, workflow, nextStatusId);
        }
        return false;
    }

    private boolean isEditableInWorkflow(@Nonnull Issue issue, @Nonnull JiraWorkflow workflow, @Nonnull String statusId) {
        try {
            StepDescriptor currentStep = workflow.getLinkedStep(this.getConstantsManager().getStatus(statusId));
            return currentStep == null || !"false".equals(currentStep.getMetaAttributes().get("jira.issue.editable"));
        }
        catch (WorkflowException e) {
            throw new RuntimeException((Object)((Object)e) + " when trying to access workflow for issue " + issue, e);
        }
    }

    private ConstantsManager getConstantsManager() {
        return ComponentAccessor.getConstantsManager();
    }

    protected Configuration getConfiguration() {
        return this.configuration;
    }

    public Map<ActionDescriptor, Collection<FunctionDescriptor>> getPostFunctionsForWorkflow(JiraWorkflow workflow) {
        HashMap<ActionDescriptor, Collection<FunctionDescriptor>> transitionPostFunctionMap = new HashMap<ActionDescriptor, Collection<FunctionDescriptor>>();
        Collection actions = workflow.getAllActions();
        for (ActionDescriptor actionDescriptor : actions) {
            Collection postFunctions = workflow.getPostFunctionsForTransition(actionDescriptor);
            transitionPostFunctionMap.put(actionDescriptor, postFunctions);
        }
        return transitionPostFunctionMap;
    }

    public String getStepId(long actionDescriptorId, String workflowName) {
        String stepId;
        block0: {
            Collection stepsForTransition;
            Iterator iterator;
            int actionDescId = new Long(actionDescriptorId).intValue();
            stepId = null;
            JiraWorkflow workflow = this.getWorkflow(workflowName);
            ActionDescriptor actionDescriptor = workflow.getDescriptor().getAction(actionDescId);
            if (actionDescriptor == null || !(iterator = (stepsForTransition = workflow.getStepsForTransition(actionDescriptor)).iterator()).hasNext()) break block0;
            StepDescriptor stepDescriptor = (StepDescriptor)iterator.next();
            stepId = String.valueOf(stepDescriptor.getId());
        }
        return stepId;
    }

    public void replaceConditionInTransition(ActionDescriptor transition, Map<String, String> matchMap, Map<String, String> newMap) {
        ConditionsDescriptor conditionsDescriptor = transition.getRestriction().getConditionsDescriptor();
        if (conditionsDescriptor == null) {
            return;
        }
        this.replaceConditionInConditionsDescriptor(conditionsDescriptor, matchMap, newMap);
    }

    private void replaceConditionInConditionsDescriptor(ConditionsDescriptor descriptor, Map<String, String> matchMap, Map modifyMap) {
        List conditions = descriptor.getConditions();
        for (Object condition : conditions) {
            ConditionDescriptor conditionDescriptor;
            if (condition instanceof ConditionsDescriptor) {
                this.replaceConditionInConditionsDescriptor((ConditionsDescriptor)condition, matchMap, modifyMap);
                continue;
            }
            if (!(condition instanceof ConditionDescriptor) || !this.hasKeyValuesInArgMap(conditionDescriptor = (ConditionDescriptor)condition, matchMap)) continue;
            conditionDescriptor.getArgs().putAll(modifyMap);
        }
    }

    private boolean hasKeyValuesInArgMap(ConditionDescriptor descriptor, Map<String, String> descriptorArguments) {
        Map argMap = descriptor.getArgs();
        for (String key : descriptorArguments.keySet()) {
            if (argMap.containsKey(key) && argMap.get(key).equals(descriptorArguments.get(key))) continue;
            return false;
        }
        return true;
    }

    private IssueManager getIssueManager() {
        return ComponentAccessor.getIssueManager();
    }
}

