/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow.edit.utilities;

import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.workflow.edit.utilities.ScreenNameResolver;
import com.opensymphony.workflow.loader.ActionDescriptor;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public class ScreenNameResolverImpl
implements ScreenNameResolver {
    private final FieldScreenManager fieldScreenManager;

    public ScreenNameResolverImpl(FieldScreenManager fieldScreenManager) {
        this.fieldScreenManager = fieldScreenManager;
    }

    @Override
    public String getScreenName(@Nonnull ActionDescriptor actionDescriptor) {
        Object o = actionDescriptor.getMetaAttributes().get("jira.fieldscreen.id");
        if (!(o instanceof String)) {
            return null;
        }
        String id = (String)o;
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        try {
            Long screenId = Long.parseLong(id, 10);
            FieldScreen fieldScreen = this.fieldScreenManager.getFieldScreen(screenId);
            return Optional.ofNullable(fieldScreen).map(FieldScreen::getName).orElse(null);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

