/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow.function.issue;

import com.atlassian.jira.auditing.handlers.IssueStateAuditHandler;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.ModifiedValue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.util.InlineIssuePropertySetter;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.FunctionProvider;
import com.opensymphony.workflow.StoreException;
import com.opensymphony.workflow.WorkflowException;
import com.opensymphony.workflow.loader.DescriptorFactory;
import com.opensymphony.workflow.loader.FunctionDescriptor;
import com.opensymphony.workflow.loader.StepDescriptor;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import com.opensymphony.workflow.spi.Step;
import com.opensymphony.workflow.spi.WorkflowEntry;
import com.opensymphony.workflow.spi.WorkflowStore;
import java.sql.Timestamp;
import java.util.Map;

public class IssueCreateFunction
implements FunctionProvider {
    public void execute(Map transientVars, Map args, PropertySet ps) throws WorkflowException {
        try {
            FieldManager fieldManager = this.getComponentOfType(FieldManager.class);
            MutableIssue issue = (MutableIssue)this.cast(transientVars.get("issue"));
            Timestamp now = new Timestamp(System.currentTimeMillis());
            if (issue.getCreated() == null) {
                issue.setCreated(now);
            }
            if (issue.getUpdated() == null) {
                issue.setUpdated(now);
            }
            Project project = issue.getProjectObject();
            long incCount = this.getComponentOfType(ProjectManager.class).getNextId(project);
            issue.setKey(project.getKey() + "-" + incCount);
            if (issue.getVotes() == null) {
                issue.setVotes(Long.valueOf(0L));
            }
            if (issue.getWatches() == null) {
                issue.setWatches(Long.valueOf(0L));
            }
            WorkflowEntry entry = (WorkflowEntry)this.cast(transientVars.get("entry"));
            issue.setWorkflowId(Long.valueOf(entry.getId()));
            WorkflowStore store = (WorkflowStore)this.cast(transientVars.get("store"));
            Step step = (Step)this.cast(store.findCurrentSteps(entry.getId()).get(0));
            WorkflowDescriptor descriptor = (WorkflowDescriptor)this.cast(transientVars.get("descriptor"));
            StepDescriptor stepDescriptor = descriptor.getStep(step.getStepId());
            issue.setStatusId((String)this.cast(stepDescriptor.getMetaAttributes().get("jira.status.id")));
            issue.store();
            this.getComponentOfType(IssueStateAuditHandler.class).onIssueCreated((Issue)issue);
            Map modifiedFields = issue.getModifiedFields();
            for (String fieldId : modifiedFields.keySet()) {
                if (!fieldManager.isOrderableField(fieldId)) continue;
                OrderableField field = fieldManager.getOrderableField(fieldId);
                Object newValue = ((ModifiedValue)modifiedFields.get(fieldId)).getNewValue();
                if (newValue == null) continue;
                field.createValue((Issue)issue, newValue);
            }
            transientVars.put("modifiedFields", ImmutableMap.copyOf((Map)issue.getModifiedFields()));
            issue.resetModifiedFields();
            this.setIssueProperties(issue.getId(), transientVars);
        }
        catch (StoreException e) {
            throw new WorkflowException((Throwable)e);
        }
    }

    public static FunctionDescriptor makeDescriptor() {
        FunctionDescriptor descriptor = DescriptorFactory.getFactory().createFunctionDescriptor();
        descriptor.setType("class");
        descriptor.getArgs().put("class.name", IssueCreateFunction.class.getName());
        return descriptor;
    }

    private void setIssueProperties(Long issueId, Map transientVars) {
        Map issueProperties = (Map)this.cast(transientVars.get("issueProperties"));
        ApplicationUser user = (ApplicationUser)this.cast(transientVars.get("user"));
        if (issueProperties != null) {
            InlineIssuePropertySetter propertySetter = this.getComponentOfType(InlineIssuePropertySetter.class);
            propertySetter.setIssueProperties(user, issueId, issueProperties, false);
        }
    }

    private <T> T cast(Object obj) {
        return (T)obj;
    }

    @VisibleForTesting
    <T> T getComponentOfType(Class<T> componentClass) {
        return (T)ComponentAccessor.getComponentOfType(componentClass);
    }
}

