/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.query;

import com.atlassian.jira.JiraDataTypes;
import com.atlassian.jira.issue.search.managers.SearchHandlerManager;
import com.atlassian.jira.jql.resolver.UserResolver;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.query.PersonalDataInQueryFindingService;
import com.atlassian.query.Query;
import com.atlassian.query.clause.AndClause;
import com.atlassian.query.clause.ChangedClause;
import com.atlassian.query.clause.ClauseVisitor;
import com.atlassian.query.clause.NotClause;
import com.atlassian.query.clause.OrClause;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.clause.WasClause;
import com.atlassian.query.history.AndHistoryPredicate;
import com.atlassian.query.history.HistoryPredicate;
import com.atlassian.query.history.PredicateVisitor;
import com.atlassian.query.history.TerminalHistoryPredicate;
import com.atlassian.query.operand.EmptyOperand;
import com.atlassian.query.operand.FunctionOperand;
import com.atlassian.query.operand.MultiValueOperand;
import com.atlassian.query.operand.Operand;
import com.atlassian.query.operand.OperandVisitor;
import com.atlassian.query.operand.SingleValueOperand;
import com.atlassian.query.operator.Operator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class PersonalDataInQueryFindingServiceImpl
implements PersonalDataInQueryFindingService {
    private final UserResolver userResolver;
    private final SearchHandlerManager searchHandlerManager;

    public PersonalDataInQueryFindingServiceImpl(UserResolver userResolver, SearchHandlerManager searchHandlerManager) {
        this.userResolver = userResolver;
        this.searchHandlerManager = searchHandlerManager;
    }

    public PersonalDataInQueryFindingService.UserDataInQuery containsUserData(ApplicationUser user, Query query) {
        if (query.getWhereClause() != null) {
            return (PersonalDataInQueryFindingService.UserDataInQuery)query.getWhereClause().accept((ClauseVisitor)new PersonalDataFindingClauseVisitor(user));
        }
        return PersonalDataInQueryFindingService.UserDataInQuery.NO;
    }

    private PersonalDataInQueryFindingService.UserDataInQuery refersToUser(ApplicationUser user, String value) {
        List matches = this.userResolver.getIdsFromName(value);
        if (matches.size() == 1) {
            return matches.contains(user.getKey()) ? PersonalDataInQueryFindingService.UserDataInQuery.YES : PersonalDataInQueryFindingService.UserDataInQuery.NO;
        }
        return matches.contains(user.getKey()) ? PersonalDataInQueryFindingService.UserDataInQuery.MAYBE : PersonalDataInQueryFindingService.UserDataInQuery.NO;
    }

    private class PersonalDataFindingOperandVisitor
    implements OperandVisitor<PersonalDataInQueryFindingService.UserDataInQuery> {
        private final ApplicationUser user;

        public PersonalDataFindingOperandVisitor(ApplicationUser user) {
            this.user = user;
        }

        public PersonalDataInQueryFindingService.UserDataInQuery visit(EmptyOperand empty) {
            return PersonalDataInQueryFindingService.UserDataInQuery.NO;
        }

        public PersonalDataInQueryFindingService.UserDataInQuery visit(FunctionOperand function) {
            PersonalDataInQueryFindingService.UserDataInQuery foundInArgs = function.getArgs().stream().map(arg -> PersonalDataInQueryFindingServiceImpl.this.refersToUser(this.user, arg)).sorted().findFirst().orElse(PersonalDataInQueryFindingService.UserDataInQuery.NO);
            return foundInArgs == PersonalDataInQueryFindingService.UserDataInQuery.NO ? PersonalDataInQueryFindingService.UserDataInQuery.NO : PersonalDataInQueryFindingService.UserDataInQuery.MAYBE;
        }

        public PersonalDataInQueryFindingService.UserDataInQuery visit(MultiValueOperand multiValue) {
            return multiValue.getValues().stream().map(o -> (PersonalDataInQueryFindingService.UserDataInQuery)o.accept((OperandVisitor)this)).sorted().findFirst().orElse(PersonalDataInQueryFindingService.UserDataInQuery.NO);
        }

        public PersonalDataInQueryFindingService.UserDataInQuery visit(SingleValueOperand singleValueOperand) {
            if (singleValueOperand.getStringValue() != null) {
                return PersonalDataInQueryFindingServiceImpl.this.refersToUser(this.user, singleValueOperand.getStringValue());
            }
            return PersonalDataInQueryFindingService.UserDataInQuery.NO;
        }
    }

    private class PersonalDataFindingClauseVisitor
    implements ClauseVisitor<PersonalDataInQueryFindingService.UserDataInQuery> {
        private final ApplicationUser user;

        public PersonalDataFindingClauseVisitor(ApplicationUser user) {
            this.user = user;
        }

        public PersonalDataInQueryFindingService.UserDataInQuery visit(AndClause andClause) {
            return andClause.getClauses().stream().map(clause -> (PersonalDataInQueryFindingService.UserDataInQuery)clause.accept((ClauseVisitor)this)).sorted().findFirst().orElse(PersonalDataInQueryFindingService.UserDataInQuery.NO);
        }

        public PersonalDataInQueryFindingService.UserDataInQuery visit(NotClause notClause) {
            return (PersonalDataInQueryFindingService.UserDataInQuery)notClause.getSubClause().accept((ClauseVisitor)this);
        }

        public PersonalDataInQueryFindingService.UserDataInQuery visit(OrClause orClause) {
            return orClause.getClauses().stream().map(clause -> (PersonalDataInQueryFindingService.UserDataInQuery)clause.accept((ClauseVisitor)this)).sorted().findFirst().orElse(PersonalDataInQueryFindingService.UserDataInQuery.NO);
        }

        public PersonalDataInQueryFindingService.UserDataInQuery visit(TerminalClause clause) {
            if (this.isUserClause(clause.getName()) || this.isUserFunctionOperand(clause.getOperand())) {
                return (PersonalDataInQueryFindingService.UserDataInQuery)clause.getOperand().accept((OperandVisitor)new PersonalDataFindingOperandVisitor(this.user));
            }
            return PersonalDataInQueryFindingService.UserDataInQuery.NO;
        }

        private boolean isUserFunctionOperand(Operand maybeFunction) {
            return maybeFunction instanceof FunctionOperand;
        }

        public PersonalDataInQueryFindingService.UserDataInQuery visit(WasClause clause) {
            PersonalDataInQueryFindingService.UserDataInQuery userInPredicate = this.visitPredicateOperands(clause.getPredicate(), new PersonalDataFindingOperandVisitor(this.user)).sorted().findFirst().orElse(PersonalDataInQueryFindingService.UserDataInQuery.NO);
            PersonalDataInQueryFindingService.UserDataInQuery userInOperand = this.isUserClause(clause.getField()) ? (PersonalDataInQueryFindingService.UserDataInQuery)clause.getOperand().accept((OperandVisitor)new PersonalDataFindingOperandVisitor(this.user)) : PersonalDataInQueryFindingService.UserDataInQuery.NO;
            return userInPredicate.compareTo((Enum)userInOperand) > 0 ? userInOperand : userInPredicate;
        }

        public PersonalDataInQueryFindingService.UserDataInQuery visit(ChangedClause clause) {
            if (this.isUserClause(clause.getField())) {
                return this.visitPredicateOperands(clause.getPredicate(), new PersonalDataFindingOperandVisitor(this.user)).sorted().findFirst().orElse(PersonalDataInQueryFindingService.UserDataInQuery.NO);
            }
            return this.hasUserPredicate(clause.getPredicate());
        }

        private PersonalDataInQueryFindingService.UserDataInQuery hasUserPredicate(HistoryPredicate predicate) {
            return this.visitPredicate(predicate, p -> p.getOperator() == Operator.BY ? (PersonalDataInQueryFindingService.UserDataInQuery)p.getOperand().accept((OperandVisitor)new PersonalDataFindingOperandVisitor(this.user)) : PersonalDataInQueryFindingService.UserDataInQuery.NO).sorted().findFirst().orElse(PersonalDataInQueryFindingService.UserDataInQuery.NO);
        }

        private boolean isUserClause(String name) {
            Set types = PersonalDataInQueryFindingServiceImpl.this.searchHandlerManager.getClauseHandler(name).stream().map(c -> c.getInformation().getDataType()).collect(Collectors.toSet());
            return types.contains(JiraDataTypes.USER);
        }

        private <T> Stream<T> visitPredicate(HistoryPredicate predicate, final Function<TerminalHistoryPredicate, T> visitor) {
            return (Stream)predicate.accept(new PredicateVisitor<Stream<T>>(){

                public Stream<T> visit(HistoryPredicate predicate) {
                    if (predicate instanceof AndHistoryPredicate) {
                        return ((AndHistoryPredicate)predicate).getPredicates().stream().flatMap(p -> (Stream)p.accept((PredicateVisitor)this));
                    }
                    return Stream.of(visitor.apply((TerminalHistoryPredicate)predicate));
                }
            });
        }

        private <T> Stream<T> visitPredicateOperands(@Nullable HistoryPredicate predicate, OperandVisitor<T> visitor) {
            if (predicate != null) {
                return this.visitPredicate(predicate, p -> p.getOperand().accept(visitor));
            }
            return Stream.of(new Object[0]);
        }
    }
}

