/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.query.clause;

import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.ClauseVisitor;
import com.atlassian.query.clause.Property;
import com.atlassian.query.clause.WasClause;
import com.atlassian.query.history.HistoryPredicate;
import com.atlassian.query.operand.Operand;
import com.atlassian.query.operator.Operator;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class WasClauseImpl
implements WasClause {
    String field;
    Operand operand;
    Operator operator;
    HistoryPredicate predicate;
    List<Clause> subClauses = new ArrayList<Clause>();
    private String displayString = "was";

    public WasClauseImpl(String field, Operator operator, Operand operand, HistoryPredicate predicate) {
        this.field = (String)Assertions.notNull((String)"field", (Object)field);
        this.operand = (Operand)Assertions.notNull((String)"operand", (Object)operand);
        this.operator = operator;
        this.predicate = predicate;
    }

    public WasClauseImpl(WasClause clause) {
        Assertions.notNull((String)"Was Clause", (Object)clause);
        this.field = clause.getField();
        this.operand = clause.getOperand();
        this.predicate = clause.getPredicate();
        this.operator = clause.getOperator();
    }

    public <R> R accept(ClauseVisitor<R> visitor) {
        return (R)visitor.visit((WasClause)this);
    }

    public String getName() {
        return this.getField();
    }

    public List<Clause> getClauses() {
        return Collections.unmodifiableList(this.subClauses);
    }

    public Operand getOperand() {
        return this.operand;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public Option<Property> getProperty() {
        return Option.none();
    }

    public String getField() {
        return this.field;
    }

    public HistoryPredicate getPredicate() {
        return this.predicate;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{").append(this.getName());
        sb.append(" ").append("was").append(" ").append(this.operand.getDisplayString());
        if (this.predicate != null) {
            sb.append(" ").append(this.predicate.getDisplayString());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WasClauseImpl that = (WasClauseImpl)o;
        if (!this.field.equals(that.field)) {
            return false;
        }
        if (!this.operand.equals(that.operand)) {
            return false;
        }
        return this.predicate == null || this.predicate.equals(that.predicate);
    }

    public int hashCode() {
        int result = this.operand.hashCode();
        if (this.predicate != null) {
            result = 31 * result + (this.predicate == null ? 0 : this.predicate.hashCode());
        }
        result = 31 * result + this.field.hashCode();
        return result;
    }

    public String getDisplayString() {
        return this.displayString;
    }
}

