/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.velocity;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;

final class TrackedClasses {
    private static final Predicate<String> ARRAY_OF_PRIMITIVES = Pattern.compile("\\[+[ZBCDFIJS]").asPredicate();
    private static final Pattern ARRAY_OF_OBJECTS = Pattern.compile("\\[+L(\\S+);");
    private static final Pattern LAMBDA = Pattern.compile("(\\S+\\$\\$Lambda)\\S+");
    private final Object callerInstance;
    private final Object[] callerArgsInstances;

    TrackedClasses(Object callerInstance, Object ... callerArgsInstances) {
        this.callerInstance = callerInstance;
        this.callerArgsInstances = callerArgsInstances;
    }

    TrackedClasses(Object callerInstance) {
        this(callerInstance, new Object[0]);
    }

    Stream<String> filter(Predicate<String> predicate) {
        return Stream.concat(Stream.of(this.callerInstance), Arrays.stream(this.callerArgsInstances)).filter(Objects::nonNull).map(this::getSanitizedName).filter(predicate);
    }

    private String getSanitizedName(Object object) {
        Class<?> clazz = object.getClass();
        String className = clazz.getName();
        if (!clazz.isArray()) {
            Matcher matcher = LAMBDA.matcher(className);
            return matcher.matches() ? matcher.group(1) : className;
        }
        if (ARRAY_OF_PRIMITIVES.test(className)) {
            return "primitive";
        }
        Matcher matcher = ARRAY_OF_OBJECTS.matcher(className);
        if (!matcher.matches()) {
            throw new IllegalStateException(className + " should be an array of objects.");
        }
        return matcher.group(1);
    }
}

