/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.avatar;

import com.atlassian.core.util.thumbnail.Thumber;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarImageDataProvider;
import com.atlassian.jira.avatar.AvatarTagger;
import com.atlassian.jira.avatar.CroppingAvatarImageDataProviderFactory;
import com.atlassian.jira.avatar.ImageScaler;
import com.atlassian.jira.avatar.Selection;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CroppingAvatarImageDataProviderFactoryImpl
implements CroppingAvatarImageDataProviderFactory {
    private final AvatarTagger avatarTagger;
    private final String targetFormat;
    private final Thumber thumber;
    private final ImageScaler scaler;

    public CroppingAvatarImageDataProviderFactoryImpl(AvatarTagger avatarTagger, ImageScaler scaler) {
        this.scaler = scaler;
        this.thumber = new Thumber();
        this.avatarTagger = avatarTagger;
        this.targetFormat = "png";
    }

    public AvatarImageDataProvider createStreamsFrom(InputStream uploadedImage, Selection cropping) throws IOException {
        return new AvatarImageDataProviderImpl(uploadedImage, cropping);
    }

    private void cropImageToSize(BufferedImage imageData, Selection croppingSelection, Avatar.Size size, OutputStream target) throws IOException {
        int pixels = size.getPixels();
        RenderedImage image = this.cropImage(imageData, croppingSelection, pixels);
        this.avatarTagger.saveTaggedAvatar(image, this.targetFormat, target);
    }

    private RenderedImage cropImage(BufferedImage image, Selection croppingSelection, int pixels) throws IOException {
        return this.scaler.getSelectedImageData(image, croppingSelection, pixels);
    }

    private class AvatarImageDataProviderImpl
    implements AvatarImageDataProvider {
        final BufferedImage uploadedImage;
        final Selection cropping;

        private AvatarImageDataProviderImpl(InputStream uploadedImage, Selection cropping) throws IOException {
            this.uploadedImage = CroppingAvatarImageDataProviderFactoryImpl.this.thumber.getImage(uploadedImage);
            this.cropping = cropping;
        }

        public void storeImage(Avatar.Size requestSize, OutputStream output) throws IOException {
            CroppingAvatarImageDataProviderFactoryImpl.this.cropImageToSize(this.uploadedImage, this.cropping, requestSize, output);
        }
    }
}

