/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.avatar;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarImageResolver;
import com.atlassian.jira.avatar.TypeAvatarService;
import com.atlassian.jira.avatar.UniversalAvatarsService;
import com.atlassian.jira.avatar.types.issuetype.IssueTypeAvatarImageResolver;
import com.atlassian.jira.avatar.types.issuetype.IssueTypeTypeAvatarService;
import com.atlassian.jira.avatar.types.project.ProjectAvatarImageResolver;
import com.atlassian.jira.avatar.types.project.ProjectTypeAvatarService;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public class UniversalAvatarsServiceImpl
implements UniversalAvatarsService {
    private final Map<Avatar.Type, TypeAvatarsAndUris> typeAvatars;

    public UniversalAvatarsServiceImpl(IssueTypeTypeAvatarService issueTypeAvatars, IssueTypeAvatarImageResolver issueTypeAvatarUris, ProjectTypeAvatarService projectAvatars, ProjectAvatarImageResolver projectAvatarUriResolver) {
        this.typeAvatars = ImmutableMap.builder().put((Object)Avatar.Type.ISSUETYPE, (Object)new TypeAvatarsAndUris(issueTypeAvatars, issueTypeAvatarUris)).put((Object)Avatar.Type.PROJECT, (Object)new TypeAvatarsAndUris(projectAvatars, projectAvatarUriResolver)).build();
    }

    public TypeAvatarService getAvatars(Avatar.Type type) {
        TypeAvatarsAndUris typeItems = this.typeAvatars.get(type);
        return typeItems == null ? null : typeItems.avatars;
    }

    public AvatarImageResolver getImages(Avatar.Type type) {
        TypeAvatarsAndUris typeItems = this.typeAvatars.get(type);
        return typeItems == null ? null : typeItems.uriResolver;
    }

    private static class TypeAvatarsAndUris {
        final TypeAvatarService avatars;
        final AvatarImageResolver uriResolver;

        TypeAvatarsAndUris(TypeAvatarService avatars, AvatarImageResolver uriResolver) {
            this.avatars = avatars;
            this.uriResolver = uriResolver;
        }
    }
}

