/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.dataimport.ha;

import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.bc.dataimport.ImportCompletedEvent;
import com.atlassian.jira.bc.dataimport.ImportStartedEvent;
import com.atlassian.jira.bc.dataimport.ha.ClusterImportService;
import com.atlassian.jira.bc.dataimport.ha.RemoteImportCompletedEvent;
import com.atlassian.jira.cluster.EventMessageConsumer;
import com.atlassian.jira.cluster.MessageHandlerService;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevel;
import com.atlassian.johnson.event.EventType;

@EventComponent
public class ClusterImportListener {
    private final MessageHandlerService messageHandlerService;
    private final ClusterImportService clusterImportService;
    private final Event importEvent = new Event(EventType.get((String)"import"), "JIRA is currently being restored from backup", EventLevel.get((String)"warning"));

    public ClusterImportListener(MessageHandlerService messageHandlerService, ClusterImportService clusterImportService) {
        this.messageHandlerService = messageHandlerService;
        this.clusterImportService = clusterImportService;
    }

    @EventListener
    public void onImportStarted(ImportStartedEvent importStartedEvent) {
        this.messageHandlerService.sendMessage("ALL", EventMessageConsumer.importStartedMessage());
    }

    @EventListener
    public void onImportCompleted(ImportCompletedEvent importCompletedEvent) {
        this.clusterImportService.prepareImport();
        this.messageHandlerService.sendMessage("ALL", EventMessageConsumer.importFinishedMessage(importCompletedEvent.isImportSuccessful()));
    }

    @EventListener
    public void onRemoteImportCompleted(RemoteImportCompletedEvent remoteImportCompletedEvent) {
        if (remoteImportCompletedEvent.isImportSuccessful()) {
            this.clusterImportService.doImport(remoteImportCompletedEvent.getIndexBackupFileName());
        }
    }
}

