/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.filter;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.fugue.Option;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.filter.ProjectSearchRequestService;
import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.bc.project.ProjectAction;
import com.atlassian.jira.bc.project.property.ProjectPropertyService;
import com.atlassian.jira.entity.property.EntityProperty;
import com.atlassian.jira.entity.property.EntityPropertyService;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.json.JSONArray;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectSearchRequestServiceImpl
implements ProjectSearchRequestService {
    private static final Logger log = LoggerFactory.getLogger(ProjectSearchRequestServiceImpl.class);
    private static final String PROJECT_SEARCH_REQUESTS_KEY = "searchRequests";
    private static final String IDS = "ids";
    private final PermissionManager permissionManager;
    private final ProjectPropertyService projectPropertyService;
    private final I18nHelper.BeanFactory i18nFactory;
    private final SearchRequestService searchRequestService;

    public ProjectSearchRequestServiceImpl(PermissionManager permissionManager, ProjectPropertyService projectPropertyService, I18nHelper.BeanFactory i18nFactory, SearchRequestService searchRequestService) {
        this.permissionManager = permissionManager;
        this.projectPropertyService = projectPropertyService;
        this.i18nFactory = i18nFactory;
        this.searchRequestService = searchRequestService;
    }

    public ServiceOutcome<List<SearchRequest>> associateSearchRequestsWithProject(ApplicationUser user, @Nonnull Project project, Long ... searchRequestIds) {
        if (!ProjectAction.EDIT_PROJECT_CONFIG.hasPermission(this.permissionManager, user, project)) {
            return ServiceOutcomeImpl.error(this.i18nFactory.getInstance(user).getText(ProjectAction.EDIT_PROJECT_CONFIG.getErrorKey()), ErrorCollection.Reason.FORBIDDEN);
        }
        EntityPropertyService.SetPropertyValidationResult result = this.projectPropertyService.validateSetProperty(user, project.getId(), this.toPropertyInput(this.toJSON(user, searchRequestIds)));
        if (!result.isValid()) {
            return ServiceOutcomeImpl.from(result.getErrorCollection());
        }
        this.projectPropertyService.setProperty(user, result);
        return ServiceOutcomeImpl.ok(this.getSearchRequestsWithoutPermissionCheck(user, project));
    }

    public List<SearchRequest> getSearchRequestsForProject(ApplicationUser user, @Nonnull Project project) {
        if (!ProjectAction.VIEW_ISSUES.hasPermission(this.permissionManager, user, project)) {
            return Collections.emptyList();
        }
        return this.getSearchRequestsWithoutPermissionCheck(user, project);
    }

    private List<SearchRequest> getSearchRequestsWithoutPermissionCheck(ApplicationUser user, @Nonnull Project project) {
        Option entityProperty;
        EntityPropertyService.PropertyResult result = this.projectPropertyService.getProperty(user, project.getId(), PROJECT_SEARCH_REQUESTS_KEY);
        if (result.isValid() && (entityProperty = result.getEntityProperty()).isDefined()) {
            String value = ((EntityProperty)entityProperty.get()).getValue();
            try {
                JSONObject json = new JSONObject(value);
                return this.toSearchRequests(user, json);
            }
            catch (JSONException e) {
                log.error("Error converting value '{0}' to JSONObject.", (Object)value, (Object)e);
            }
        }
        return Collections.emptyList();
    }

    private List<SearchRequest> toSearchRequests(ApplicationUser user, JSONObject json) throws JSONException {
        JSONArray jsonArray = json.getJSONArray(IDS);
        ArrayList filters = Lists.newArrayList();
        for (int i = 0; i < jsonArray.length(); ++i) {
            long filterId = jsonArray.getLong(i);
            SearchRequest filter = this.searchRequestService.getFilter((JiraServiceContext)new JiraServiceContextImpl(user), Long.valueOf(filterId));
            if (filter == null) continue;
            filters.add(filter);
        }
        return ImmutableList.copyOf((Collection)filters);
    }

    private EntityPropertyService.PropertyInput toPropertyInput(JSONObject jsonObject) {
        return new EntityPropertyService.PropertyInput(jsonObject.toString(), PROJECT_SEARCH_REQUESTS_KEY);
    }

    private JSONObject toJSON(ApplicationUser user, Long[] searchRequestIds) {
        JiraServiceContextImpl ctx = new JiraServiceContextImpl(user);
        ImmutableList validatedIds = (ImmutableList)Arrays.stream(searchRequestIds).map(arg_0 -> this.lambda$toJSON$451((JiraServiceContext)ctx, arg_0)).filter(Objects::nonNull).map(SearchRequest::getId).collect(CollectorsUtil.toImmutableList());
        try {
            return new JSONObject().put(IDS, (Object)validatedIds);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    private /* synthetic */ SearchRequest lambda$toJSON$451(JiraServiceContext ctx, Long id) {
        return this.searchRequestService.getFilter(ctx, id);
    }
}

