/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.group;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.exception.InvalidMembershipException;
import com.atlassian.crowd.exception.OperationNotPermittedException;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.jira.application.ApplicationRole;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.group.GroupRemoveChildMapper;
import com.atlassian.jira.bc.group.GroupService;
import com.atlassian.jira.bc.group.GroupsToApplicationsSeatingHelper;
import com.atlassian.jira.bc.projectroles.ProjectRoleService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.exception.AddException;
import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.issue.comments.CommentManager;
import com.atlassian.jira.issue.security.IssueSecurityLevelManager;
import com.atlassian.jira.issue.subscription.SubscriptionManager;
import com.atlassian.jira.issue.worklog.WorklogManager;
import com.atlassian.jira.notification.NotificationSchemeManager;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.sharing.SharePermissionDeleteUtils;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.GlobalPermissionGroupAssociationUtil;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraContactHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultGroupService
implements GroupService {
    private static final Logger log = LoggerFactory.getLogger(DefaultGroupService.class);
    private static final int MAX_REPORTABLE_ERRORS = 5;
    private final GlobalPermissionManager globalPermissionManager;
    private final GlobalPermissionGroupAssociationUtil globalPermissionGroupAssociationUtil;
    private final CommentManager commentManager;
    private final WorklogManager worklogManager;
    private final NotificationSchemeManager notificationSchemeManager;
    private final PermissionManager permissionManager;
    private final ProjectRoleService projectRoleService;
    private final IssueSecurityLevelManager issueSecurityLevelManager;
    private final UserUtil userUtil;
    private final SharePermissionDeleteUtils sharePermissionDeleteUtils;
    private final SubscriptionManager subscriptionManager;
    private final CrowdService crowdService;
    private final GroupManager groupManager;
    private final JiraContactHelper jiraContactHelper;
    private final ApplicationRoleManager applicationRoleManager;
    private final GroupsToApplicationsSeatingHelper groupsToApplicationsSeatingHelper;

    public DefaultGroupService(GlobalPermissionManager globalPermissionManager, GlobalPermissionGroupAssociationUtil globalPermissionGroupAssociationUtil, CommentManager commentManager, WorklogManager worklogManager, NotificationSchemeManager notificationSchemeManager, PermissionManager permissionManager, ProjectRoleService projectRoleService, IssueSecurityLevelManager issueSecurityLevelManager, UserUtil userUtil, SharePermissionDeleteUtils sharePermissionDeleteUtils, SubscriptionManager subscriptionManager, CrowdService crowdService, JiraContactHelper jiraContactHelper, GroupManager groupManager, @Nonnull ApplicationRoleManager applicationRoleManager, GroupsToApplicationsSeatingHelper groupsToApplicationsSeatingHelper) {
        this.globalPermissionManager = globalPermissionManager;
        this.globalPermissionGroupAssociationUtil = globalPermissionGroupAssociationUtil;
        this.commentManager = commentManager;
        this.worklogManager = worklogManager;
        this.notificationSchemeManager = notificationSchemeManager;
        this.permissionManager = permissionManager;
        this.projectRoleService = projectRoleService;
        this.issueSecurityLevelManager = issueSecurityLevelManager;
        this.userUtil = userUtil;
        this.sharePermissionDeleteUtils = sharePermissionDeleteUtils;
        this.subscriptionManager = subscriptionManager;
        this.crowdService = crowdService;
        this.jiraContactHelper = jiraContactHelper;
        this.groupManager = groupManager;
        this.applicationRoleManager = applicationRoleManager;
        this.groupsToApplicationsSeatingHelper = groupsToApplicationsSeatingHelper;
    }

    public boolean validateDelete(JiraServiceContext jiraServiceContext, String groupName, String swapGroup) {
        this.validateJiraServiceContext(jiraServiceContext);
        ErrorCollection errorCollection = jiraServiceContext.getErrorCollection();
        I18nHelper i18n = jiraServiceContext.getI18nBean();
        if (!this.userHasAdminPermission(jiraServiceContext.getLoggedInUser())) {
            jiraServiceContext.getErrorCollection().addErrorMessage(i18n.getText("admin.errors.groups.must.be.admin"));
            return false;
        }
        Group groupToDelete = this.getGroup(groupName);
        if (groupToDelete == null) {
            errorCollection.addErrorMessage(i18n.getText("admin.errors.groups.group.does.not.exist", groupName));
            return false;
        }
        Set roles = this.applicationRoleManager.getRoles();
        for (ApplicationRole role : roles) {
            if (!role.getDefaultGroups().equals(Collections.singleton(groupToDelete))) continue;
            errorCollection.addErrorMessage(i18n.getText("admin.errors.groups.group.is.default.group.for.application", groupName, role.getName()));
            return false;
        }
        if (this.isExternalUserManagementEnabled()) {
            String link = this.getContactAdminLink(i18n);
            errorCollection.addErrorMessage(i18n.getText("admin.errors.groups.error.external.managment", link));
            return false;
        }
        if (this.areOnlyGroupsGrantingUserAdminPermissions(jiraServiceContext, (Collection)ImmutableList.of((Object)groupName))) {
            return false;
        }
        if (this.isAdminDeletingSysAdminGroup(jiraServiceContext, groupName)) {
            return false;
        }
        if (this.getCommentsAndWorklogsGuardedByGroupCount(groupName) > 0L && swapGroup == null) {
            errorCollection.addErrorMessage(i18n.getText("admin.errors.groups.must.specify.group.to.move.comments"));
            return false;
        }
        if (swapGroup != null) {
            if (swapGroup.equalsIgnoreCase(groupName)) {
                errorCollection.addErrorMessage(i18n.getText("admin.errors.groups.cannot.swap.to.group.deleting"));
                return false;
            }
            if (this.isGroupNull(swapGroup)) {
                errorCollection.addErrorMessage(i18n.getText("admin.errors.groups.invalid.swap.group"));
                return false;
            }
        }
        return true;
    }

    public boolean delete(JiraServiceContext jiraServiceContext, String groupName, String swapGroup) {
        this.validateJiraServiceContext(jiraServiceContext);
        I18nHelper i18n = jiraServiceContext.getI18nBean();
        if (!this.userHasAdminPermission(jiraServiceContext.getLoggedInUser())) {
            jiraServiceContext.getErrorCollection().addErrorMessage(i18n.getText("admin.errors.groups.must.be.admin"));
            return false;
        }
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        try {
            this.projectRoleService.removeAllRoleActorsByNameAndType(jiraServiceContext.getLoggedInUser(), groupName, "atlassian-group-role-actor", (ErrorCollection)errorCollection);
            if (!errorCollection.hasAnyErrors()) {
                if (swapGroup != null) {
                    this.updateCommentsAndWorklogs(jiraServiceContext.getLoggedInUser(), groupName, swapGroup);
                }
                this.permissionManager.removeGroupPermissions(groupName);
                this.notificationSchemeManager.removeEntities("group", groupName);
                this.sharePermissionDeleteUtils.deleteGroupPermissions(groupName);
                Group group = this.getGroup(groupName);
                this.subscriptionManager.deleteSubscriptionsForGroup(group);
                this.applicationRoleManager.removeGroupFromRoles(group);
                this.removeGroup(group);
                this.clearIssueSecurityLevelCache();
                return true;
            }
        }
        catch (PermissionException e) {
            errorCollection.addErrorMessage(i18n.getText("admin.errors.groups.permission.removing.group"));
            log.error("Exception trying to remove group: " + (Object)((Object)e), (Throwable)e);
        }
        catch (Exception e) {
            errorCollection.addErrorMessage(i18n.getText("admin.errors.groups.error.occurred.removing.group", e.getMessage()));
            log.error("Exception trying to remove group: " + e, (Throwable)e);
        }
        jiraServiceContext.getErrorCollection().addErrorCollection((ErrorCollection)errorCollection);
        return false;
    }

    public boolean validateAddUserToGroup(JiraServiceContext jiraServiceContext, Collection<String> groupsToJoin, String userName) {
        return this.validateAddUsersToGroup(jiraServiceContext, groupsToJoin, Collections.singletonList(userName)).isSuccess();
    }

    public GroupService.BulkEditGroupValidationResult validateAddUsersToGroup(JiraServiceContext jiraServiceContext, Collection<String> groupsToJoin, Collection<String> userNames) {
        this.validateJiraServiceContext(jiraServiceContext);
        if (groupsToJoin == null) {
            throw new IllegalArgumentException("You must specify non null groupsToJoin.");
        }
        ErrorCollection errorCollection = jiraServiceContext.getErrorCollection();
        I18nHelper i18n = jiraServiceContext.getI18nBean();
        if (!this.userHasAdminPermission(jiraServiceContext.getLoggedInUser())) {
            errorCollection.addErrorMessage(i18n.getText("admin.errors.groups.must.be.admin"));
            return new GroupService.BulkEditGroupValidationResult(false);
        }
        if (!this.validateGroupNamesExist(groupsToJoin, errorCollection, i18n)) {
            return new GroupService.BulkEditGroupValidationResult(false);
        }
        if (this.isExternalUserManagementEnabled()) {
            String link = this.getContactAdminLink(i18n);
            errorCollection.addErrorMessage(i18n.getText("admin.bulkeditgroups.error.cannot.edit.user.groups.external.managment", link));
            return new GroupService.BulkEditGroupValidationResult(false);
        }
        boolean success = true;
        HashSet<String> invalidUsers = new HashSet<String>();
        HashSet<ApplicationUser> validatedUsers = new HashSet<ApplicationUser>();
        for (String userName1 : userNames) {
            String userName = userName1;
            ApplicationUser user = this.getUser(userName);
            if (this.isUserNull(user)) {
                errorCollection.addErrorMessage(i18n.getText("admin.bulkeditgroups.error.adding.invalid.user", userName));
                invalidUsers.add(userName);
                success = false;
                continue;
            }
            if (!this.getGroupNamesUserCanSee(jiraServiceContext.getLoggedInUser()).containsAll(groupsToJoin)) {
                errorCollection.addErrorMessage(i18n.getText("admin.errors.cannot.join.user.groups.not.visible"));
                success = false;
                continue;
            }
            if (!this.validateUserIsNotInSelectedGroups(jiraServiceContext, groupsToJoin, user)) {
                invalidUsers.add(userName);
                success = false;
                continue;
            }
            validatedUsers.add(user);
        }
        if (success) {
            if (!this.applicationRoleManager.rolesEnabled()) {
                if (this.doesAnyGroupGrantUserAccessToJira(groupsToJoin) && !this.canActivateUsers(userNames)) {
                    errorCollection.addErrorMessage(i18n.getText("admin.errors.edit.group.membership.exceeded.license.limit"));
                    success = false;
                    invalidUsers.addAll(userNames);
                }
            } else {
                Map<ApplicationRole, Set<ApplicationUser>> usersByApplication = this.groupsToApplicationsSeatingHelper.rolesToBeAddedForSeatingCountPurpose(validatedUsers, (Set<String>)ImmutableSet.copyOf(groupsToJoin));
                ArrayList<String> exceededApplications = new ArrayList<String>();
                for (Map.Entry<ApplicationRole, Set<ApplicationUser>> entry : usersByApplication.entrySet()) {
                    ApplicationRole application = entry.getKey();
                    if (this.applicationRoleManager.hasSeatsAvailable(application.getKey(), entry.getValue().size())) continue;
                    exceededApplications.add(application.getName());
                    success = false;
                    invalidUsers.addAll(entry.getValue().stream().map(ApplicationUser::getUsername).collect(Collectors.toList()));
                }
                if (exceededApplications.size() == 1) {
                    errorCollection.addErrorMessage(i18n.getText("admin.errors.edit.group.membership.exceeded.application.limit", (String)exceededApplications.get(0)));
                } else if (exceededApplications.size() > 1) {
                    errorCollection.addErrorMessage(i18n.getText("admin.errors.edit.group.membership.exceeded.multiple.applications.limit"));
                }
            }
        }
        return new GroupService.BulkEditGroupValidationResult(invalidUsers, success);
    }

    public GroupService.BulkEditGroupValidationResult validateAddGroupsToGroup(JiraServiceContext jiraServiceContext, Collection<String> groupsToJoin, Collection<String> groupNames) {
        this.validateJiraServiceContext(jiraServiceContext);
        if (groupsToJoin == null) {
            throw new IllegalArgumentException("You must specify non null groupsToJoin.");
        }
        ErrorCollection errorCollection = jiraServiceContext.getErrorCollection();
        I18nHelper i18n = jiraServiceContext.getI18nBean();
        if (!this.userHasAdminPermission(jiraServiceContext.getLoggedInUser())) {
            errorCollection.addErrorMessage(i18n.getText("admin.errors.groups.must.be.admin"));
            return new GroupService.BulkEditGroupValidationResult(false);
        }
        if (!this.validateGroupNamesExist(groupsToJoin, errorCollection, i18n)) {
            return new GroupService.BulkEditGroupValidationResult(false);
        }
        if (!this.validateGroupNamesNotAdmin(groupsToJoin, errorCollection, i18n)) {
            return new GroupService.BulkEditGroupValidationResult(false);
        }
        if (this.isExternalUserManagementEnabled()) {
            String link = this.getContactAdminLink(i18n);
            errorCollection.addErrorMessage(i18n.getText("admin.editnestedgroups.error.cannot.edit.group.groups.external.managment", link));
            return new GroupService.BulkEditGroupValidationResult(false);
        }
        boolean success = true;
        ArrayList invalidGroups = Lists.newArrayList();
        for (String groupName : groupNames) {
            Group group = this.getGroup(groupName);
            if (group == null) {
                errorCollection.addErrorMessage(i18n.getText("admin.errors.groups.group.does.not.exist", groupName));
                invalidGroups.add(groupName);
                success = false;
                continue;
            }
            if (this.validateGroupIsNotInSelectedGroups(jiraServiceContext, groupsToJoin, group)) continue;
            invalidGroups.add(groupName);
            success = false;
        }
        return new GroupService.BulkEditGroupValidationResult((Collection)invalidGroups, success);
    }

    public boolean addUsersToGroups(JiraServiceContext jiraServiceContext, Collection<String> groupsToJoin, Collection<String> userNames) {
        if (groupsToJoin == null) {
            throw new IllegalArgumentException("You must specify non null groupsToJoin.");
        }
        if (userNames == null) {
            throw new IllegalArgumentException("You must specify non null userNames.");
        }
        this.validateJiraServiceContext(jiraServiceContext);
        I18nHelper i18n = jiraServiceContext.getI18nBean();
        if (!this.userHasAdminPermission(jiraServiceContext.getLoggedInUser())) {
            jiraServiceContext.getErrorCollection().addErrorMessage(i18n.getText("admin.errors.groups.must.be.admin"));
            return false;
        }
        if (!this.getGroupNamesUserCanSee(jiraServiceContext.getLoggedInUser()).containsAll(groupsToJoin)) {
            jiraServiceContext.getErrorCollection().addErrorMessage(i18n.getText("admin.errors.cannot.join.user.groups.not.visible"));
            return false;
        }
        int errorCount = 0;
        boolean success = true;
        for (String userName : userNames) {
            Collection<Group> groups = this.convertGroupNamesToGroups(groupsToJoin);
            for (Group group : groups) {
                try {
                    this.userUtil.addUserToGroup(group, this.getUser(userName));
                }
                catch (PermissionException e) {
                    if (errorCount < 5) {
                        jiraServiceContext.getErrorCollection().addErrorMessage(i18n.getText("admin.errors.cannot.join.user.groups.no.permission", userName, group.getName()));
                        success = false;
                    }
                    ++errorCount;
                }
                catch (AddException e) {
                    if (errorCount < 5) {
                        jiraServiceContext.getErrorCollection().addErrorMessage(i18n.getText("admin.errors.cannot.join.user.groups.failed", userName, group.getName(), e.getMessage()));
                        success = false;
                    }
                    ++errorCount;
                }
            }
        }
        if (errorCount >= 5) {
            jiraServiceContext.getErrorCollection().addErrorMessage(i18n.getText("admin.errors.more.unreported.errors", String.valueOf(errorCount - 5 + 1)));
        }
        return success;
    }

    public boolean addGroupsToGroups(JiraServiceContext jiraServiceContext, Collection<String> groupsToJoin, Collection<String> childNames) {
        if (groupsToJoin == null) {
            throw new IllegalArgumentException("You must specify non null groupsToJoin.");
        }
        if (childNames == null) {
            throw new IllegalArgumentException("You must specify non null childNames.");
        }
        this.validateJiraServiceContext(jiraServiceContext);
        I18nHelper i18n = jiraServiceContext.getI18nBean();
        if (!this.userHasAdminPermission(jiraServiceContext.getLoggedInUser())) {
            jiraServiceContext.getErrorCollection().addErrorMessage(i18n.getText("admin.errors.groups.must.be.admin"));
            return false;
        }
        if (!this.getGroupNamesUserCanSee(jiraServiceContext.getLoggedInUser()).containsAll(groupsToJoin)) {
            jiraServiceContext.getErrorCollection().addErrorMessage(i18n.getText("admin.errors.cannot.join.group.groups.not.visible"));
            return false;
        }
        int errorCount = 0;
        boolean success = true;
        for (String childName : childNames) {
            try {
                Group child = this.getGroup(childName);
                for (String parentName : groupsToJoin) {
                    Group parent = this.getGroup(parentName);
                    this.crowdService.addGroupToGroup(child, parent);
                }
            }
            catch (OperationNotPermittedException e) {
                if (errorCount < 5) {
                    jiraServiceContext.getErrorCollection().addErrorMessage(i18n.getText("admin.errors.cannot.join.group.groups.no.permission"));
                    success = false;
                }
                ++errorCount;
            }
            catch (InvalidMembershipException e) {
                if (errorCount < 5) {
                    jiraServiceContext.getErrorCollection().addErrorMessage(e.getMessage());
                    success = false;
                }
                ++errorCount;
            }
        }
        if (errorCount >= 5) {
            jiraServiceContext.getErrorCollection().addErrorMessage(i18n.getText("admin.errors.more.unreported.errors", String.valueOf(errorCount - 5 + 1)));
        }
        return success;
    }

    public boolean validateRemoveUserFromGroups(JiraServiceContext jiraServiceContext, List groupsToLeave, String userName) {
        if (groupsToLeave == null) {
            throw new IllegalArgumentException("You must specify a non null groupsToLeave.");
        }
        GroupRemoveChildMapper groupRemoveChildMapper = new GroupRemoveChildMapper(groupsToLeave);
        groupRemoveChildMapper.register(userName, (Collection)groupsToLeave);
        return this.validateRemoveUsersFromGroups(jiraServiceContext, groupRemoveChildMapper);
    }

    public boolean validateRemoveUsersFromGroups(JiraServiceContext jiraServiceContext, GroupRemoveChildMapper mapper) {
        this.validateJiraServiceContext(jiraServiceContext);
        if (mapper == null) {
            throw new IllegalArgumentException("You must specify a non null mapper.");
        }
        ErrorCollection errorCollection = jiraServiceContext.getErrorCollection();
        I18nHelper i18n = jiraServiceContext.getI18nBean();
        if (!this.userHasAdminPermission(jiraServiceContext.getLoggedInUser())) {
            jiraServiceContext.getErrorCollection().addErrorMessage(i18n.getText("admin.errors.groups.must.be.admin"));
            return false;
        }
        if (this.isExternalUserManagementEnabled()) {
            String link = this.getContactAdminLink(i18n);
            errorCollection.addErrorMessage(i18n.getText("admin.bulkeditgroups.error.cannot.edit.user.groups.external.managment", link));
            return false;
        }
        boolean success = true;
        Iterator iterator = mapper.childIterator();
        while (iterator.hasNext()) {
            String userName = (String)iterator.next();
            ApplicationUser user = this.getUser(userName);
            if (this.isUserNull(user)) {
                errorCollection.addErrorMessage(i18n.getText("admin.bulkeditgroups.error.removing.invalid.user", userName));
                success = false;
                continue;
            }
            if (mapper.isRemoveFromAllSelected(userName)) {
                success = this.validateCanRemoveUserFromGroups(jiraServiceContext, user, mapper.getDefaultGroupNames(), mapper.getDefaultGroupNames(), true);
                continue;
            }
            Iterator groupIter = mapper.getGroupsIterator(userName);
            while (groupIter.hasNext()) {
                String groupName = (String)groupIter.next();
                success &= this.validateCanRemoveUserFromGroups(jiraServiceContext, user, mapper.getDefaultGroupNames(), (List)ImmutableList.of((Object)groupName), false);
            }
        }
        return success;
    }

    public boolean validateRemoveGroupsFromGroups(JiraServiceContext jiraServiceContext, GroupRemoveChildMapper mapper) {
        this.validateJiraServiceContext(jiraServiceContext);
        if (mapper == null) {
            throw new IllegalArgumentException("You must specify a non null mapper.");
        }
        ErrorCollection errorCollection = jiraServiceContext.getErrorCollection();
        I18nHelper i18n = jiraServiceContext.getI18nBean();
        if (!this.userHasAdminPermission(jiraServiceContext.getLoggedInUser())) {
            jiraServiceContext.getErrorCollection().addErrorMessage(i18n.getText("admin.errors.groups.must.be.admin"));
            return false;
        }
        if (this.isExternalUserManagementEnabled()) {
            String link = this.getContactAdminLink(i18n);
            errorCollection.addErrorMessage(i18n.getText("admin.editnestedgroups.error.cannot.edit.group.groups.external.managment", link));
            return false;
        }
        boolean success = true;
        Iterator iterator = mapper.childIterator();
        while (iterator.hasNext()) {
            String childName = (String)iterator.next();
            Group child = this.getGroup(childName);
            if (child == null) {
                errorCollection.addErrorMessage(i18n.getText("admin.errors.groups.group.does.not.exist", childName));
                success = false;
                continue;
            }
            if (mapper.isRemoveFromAllSelected(childName)) {
                success = this.validateCanRemoveGroupFromGroups(jiraServiceContext, child, mapper.getDefaultGroupNames(), mapper.getDefaultGroupNames(), true);
                continue;
            }
            Iterator groupIter = mapper.getGroupsIterator(childName);
            while (groupIter.hasNext()) {
                String groupName = (String)groupIter.next();
                success &= this.validateCanRemoveGroupFromGroups(jiraServiceContext, child, mapper.getDefaultGroupNames(), Collections.singletonList(groupName), false);
            }
        }
        return success;
    }

    private String getContactAdminLink(I18nHelper i18n) {
        return this.jiraContactHelper.getAdministratorContactMessage(i18n);
    }

    public boolean removeUsersFromGroups(JiraServiceContext jiraServiceContext, GroupRemoveChildMapper mapper) {
        if (mapper == null) {
            throw new IllegalArgumentException("You must specify non null mapper.");
        }
        this.validateJiraServiceContext(jiraServiceContext);
        I18nHelper i18n = jiraServiceContext.getI18nBean();
        if (!this.userHasAdminPermission(jiraServiceContext.getLoggedInUser())) {
            jiraServiceContext.getErrorCollection().addErrorMessage(i18n.getText("admin.errors.groups.must.be.admin"));
            return false;
        }
        int errorCount = 0;
        boolean success = true;
        Iterator iterator = mapper.childIterator();
        while (iterator.hasNext()) {
            String userName = (String)iterator.next();
            Collection groupsToLeave = mapper.getGroups(userName);
            if (!this.getGroupNamesUserCanSee(jiraServiceContext.getLoggedInUser()).containsAll(groupsToLeave)) {
                jiraServiceContext.getErrorCollection().addErrorMessage(i18n.getText("admin.errors.cannot.leave.user.groups.not.visible"));
                success = false;
                continue;
            }
            Collection<Group> groups = this.convertGroupNamesToGroups(groupsToLeave);
            for (Group group : groups) {
                try {
                    this.userUtil.removeUserFromGroup(group, this.getUser(userName));
                }
                catch (PermissionException e) {
                    if (errorCount < 5) {
                        jiraServiceContext.getErrorCollection().addErrorMessage(i18n.getText("admin.errors.cannot.leave.user.groups.no.permission", userName, group.getName()));
                        success = false;
                    }
                    ++errorCount;
                }
                catch (RemoveException e) {
                    if (errorCount < 5) {
                        jiraServiceContext.getErrorCollection().addErrorMessage(i18n.getText("admin.errors.cannot.leave.user.groups.failed", userName, group.getName(), e.getMessage()));
                        success = false;
                    }
                    ++errorCount;
                }
            }
        }
        if (errorCount >= 5) {
            jiraServiceContext.getErrorCollection().addErrorMessage(i18n.getText("admin.errors.more.unreported.errors", String.valueOf(errorCount - 5 + 1)));
        }
        return success;
    }

    public boolean removeGroupsFromGroups(JiraServiceContext jiraServiceContext, GroupRemoveChildMapper mapper) {
        if (mapper == null) {
            throw new IllegalArgumentException("You must specify non null mapper.");
        }
        this.validateJiraServiceContext(jiraServiceContext);
        I18nHelper i18n = jiraServiceContext.getI18nBean();
        if (!this.userHasAdminPermission(jiraServiceContext.getLoggedInUser())) {
            jiraServiceContext.getErrorCollection().addErrorMessage(i18n.getText("admin.errors.groups.must.be.admin"));
            return false;
        }
        boolean success = true;
        Iterator iterator = mapper.childIterator();
        while (iterator.hasNext()) {
            String childName = (String)iterator.next();
            Collection groupsToLeave = mapper.getGroups(childName);
            try {
                Group child = this.getGroup(childName);
                for (String parentName : groupsToLeave) {
                    Group parent = this.getGroup(parentName);
                    this.crowdService.removeGroupFromGroup(child, parent);
                }
            }
            catch (OperationNotPermittedException e) {
                jiraServiceContext.getErrorCollection().addErrorMessage(i18n.getText("admin.errors.cannot.leave.group.groups.no.permission"));
                success = false;
            }
        }
        return success;
    }

    boolean validateCanRemoveUserFromGroups(JiraServiceContext jiraServiceContext, ApplicationUser userToRemove, List allSelectedGroups, List groupsToLeave, boolean isAll) {
        ApplicationUser currentUser = jiraServiceContext.getLoggedInUser();
        I18nHelper i18n = jiraServiceContext.getI18nBean();
        ErrorCollection errorCollection = jiraServiceContext.getErrorCollection();
        if (!this.validateGroupNamesExist(groupsToLeave, errorCollection, i18n)) {
            return false;
        }
        if (!isAll && allSelectedGroups != null && !allSelectedGroups.containsAll(groupsToLeave)) {
            errorCollection.addErrorMessage(i18n.getText("admin.bulkeditgroups.error.user.group.not.selected", userToRemove.getName(), (String)groupsToLeave.get(0)));
            return false;
        }
        if (currentUser != null && currentUser.equals((Object)userToRemove) && this.areOnlyGroupsGrantingUserAdminPermissionsBulk(jiraServiceContext, groupsToLeave)) {
            return false;
        }
        if (!this.getGroupNamesUserCanSee(currentUser).containsAll(groupsToLeave)) {
            errorCollection.addErrorMessage(i18n.getText("admin.errors.cannot.leave.user.groups.not.visible"));
            return false;
        }
        if (!this.isUserInGroups(userToRemove, new HashSet<String>(groupsToLeave))) {
            if (isAll) {
                if (groupsToLeave.size() == 1) {
                    errorCollection.addErrorMessage(i18n.getText("admin.bulkeditgroups.error.user.not.member.of.group", userToRemove.getName(), (String)groupsToLeave.get(0)));
                } else {
                    errorCollection.addErrorMessage(i18n.getText("admin.bulkeditgroups.error.user.not.member.of.all", userToRemove.getName()));
                }
            } else {
                errorCollection.addErrorMessage(i18n.getText("admin.bulkeditgroups.error.user.not.member.of.group", userToRemove.getName(), (String)groupsToLeave.get(0)));
            }
            return false;
        }
        return true;
    }

    boolean validateCanRemoveGroupFromGroups(JiraServiceContext jiraServiceContext, Group childToRemove, List allSelectedGroups, List groupsToLeave, boolean isAll) {
        ApplicationUser currentUser = jiraServiceContext.getLoggedInUser();
        I18nHelper i18n = jiraServiceContext.getI18nBean();
        ErrorCollection errorCollection = jiraServiceContext.getErrorCollection();
        if (!this.validateGroupNamesExist(groupsToLeave, errorCollection, i18n)) {
            return false;
        }
        if (!isAll && allSelectedGroups != null && !allSelectedGroups.containsAll(groupsToLeave)) {
            errorCollection.addErrorMessage(i18n.getText("admin.editnestedgroups.error.group.group.not.selected", childToRemove.getName(), (String)groupsToLeave.get(0)));
            return false;
        }
        if (!this.isGroupInGroups(childToRemove, new HashSet<String>(groupsToLeave))) {
            if (isAll) {
                if (groupsToLeave.size() == 1) {
                    errorCollection.addErrorMessage(i18n.getText("admin.editnestedgroups.error.group.not.member.of.group", childToRemove.getName(), (String)groupsToLeave.get(0)));
                } else {
                    errorCollection.addErrorMessage(i18n.getText("admin.editnestedgroups.error.group.not.member.of.all", childToRemove.getName()));
                }
            } else {
                errorCollection.addErrorMessage(i18n.getText("admin.editnestedgroups.error.group.not.member.of.group", childToRemove.getName(), (String)groupsToLeave.get(0)));
            }
            return false;
        }
        return this.validateGroupNamesNotAdmin(groupsToLeave, errorCollection, i18n);
    }

    public long getCommentsAndWorklogsGuardedByGroupCount(String groupName) {
        if (groupName == null) {
            throw new IllegalArgumentException("The provided group name must not be null.");
        }
        return this.worklogManager.getCountForWorklogsRestrictedByGroup(groupName) + this.commentManager.getCountForCommentsRestrictedByGroup(groupName);
    }

    public boolean areOnlyGroupsGrantingUserAdminPermissions(JiraServiceContext jiraServiceContext, Collection groupNames) {
        return this.areOnlyGroupsGrantingUserAdminPermissions(jiraServiceContext, groupNames, "admin.errors.groups.cannot.delete.users.last.sys.admin.group", null, "admin.errors.groups.cannot.delete.users.last.admin.group", null);
    }

    boolean areOnlyGroupsGrantingUserAdminPermissionsBulk(JiraServiceContext jiraServiceContext, Collection groupNames) {
        ApplicationUser currentUser = jiraServiceContext.getLoggedInApplicationUser();
        Collection<String> sysAdminMemberGroups = this.globalPermissionGroupAssociationUtil.getSysAdminMemberGroups(currentUser);
        Collection<String> adminMemberGroups = this.globalPermissionGroupAssociationUtil.getAdminMemberGroups(currentUser);
        String sysAdminErrorMsg = "admin.errors.users.cannot.leave.sys.admin.groups";
        String adminErrorMsg = "admin.errors.users.cannot.leave.admin.groups";
        return this.areOnlyGroupsGrantingUserAdminPermissions(jiraServiceContext, groupNames, "admin.errors.users.cannot.leave.sys.admin.groups", sysAdminMemberGroups, "admin.errors.users.cannot.leave.admin.groups", adminMemberGroups);
    }

    boolean areOnlyGroupsGrantingUserAdminPermissions(JiraServiceContext jiraServiceContext, Collection<String> groupNames, String sysAdminErrorMessage, Object sysAdminErrorParameters, String adminErrorMessage, Object adminErrorParameters) {
        this.validateJiraServiceContext(jiraServiceContext);
        I18nHelper i18n = jiraServiceContext.getI18nBean();
        if (this.globalPermissionManager.hasPermission(44, jiraServiceContext.getLoggedInApplicationUser())) {
            if (this.globalPermissionGroupAssociationUtil.isRemovingAllMySysAdminGroups(groupNames, jiraServiceContext.getLoggedInApplicationUser())) {
                if (sysAdminErrorParameters == null) {
                    jiraServiceContext.getErrorCollection().addErrorMessage(i18n.getText(sysAdminErrorMessage));
                } else {
                    jiraServiceContext.getErrorCollection().addErrorMessage(i18n.getText(sysAdminErrorMessage, sysAdminErrorParameters));
                }
                return true;
            }
        } else if (this.globalPermissionGroupAssociationUtil.isRemovingAllMyAdminGroups(groupNames, jiraServiceContext.getLoggedInApplicationUser())) {
            if (adminErrorParameters == null) {
                jiraServiceContext.getErrorCollection().addErrorMessage(i18n.getText(adminErrorMessage));
            } else {
                jiraServiceContext.getErrorCollection().addErrorMessage(i18n.getText(adminErrorMessage, adminErrorParameters));
            }
            return true;
        }
        return false;
    }

    public boolean isAdminDeletingSysAdminGroup(JiraServiceContext jiraServiceContext, String groupName) {
        this.validateJiraServiceContext(jiraServiceContext);
        I18nHelper i18n = jiraServiceContext.getI18nBean();
        if (!this.globalPermissionManager.hasPermission(44, jiraServiceContext.getLoggedInUser()) && this.globalPermissionManager.getGroupNames(44).contains(groupName)) {
            jiraServiceContext.getErrorCollection().addErrorMessage(i18n.getText("admin.errors.groups.error.no.permission.to.remove.group"));
            return true;
        }
        return false;
    }

    boolean userHasAdminPermission(ApplicationUser user) {
        return this.permissionManager.hasPermission(0, user);
    }

    boolean validateUserIsNotInSelectedGroups(JiraServiceContext jiraServiceContext, Collection<String> selectedGroupsNames, ApplicationUser user) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        I18nHelper i18n = jiraServiceContext.getI18nBean();
        Collection groupsUserIsIn = CollectionUtils.intersection(this.getUserGroups(user), selectedGroupsNames);
        if (selectedGroupsNames.size() == 1 && groupsUserIsIn.size() == 1) {
            String groupName = (String)groupsUserIsIn.iterator().next();
            errorCollection.addErrorMessage(i18n.getText("admin.bulkeditgroups.error.user.already.member.of.group", user.getName(), groupName));
        } else if (selectedGroupsNames.size() == groupsUserIsIn.size()) {
            errorCollection.addErrorMessage(i18n.getText("admin.bulkeditgroups.error.user.already.member.of.all", user.getName()));
        }
        if (errorCollection.hasAnyErrors()) {
            jiraServiceContext.getErrorCollection().addErrorCollection((ErrorCollection)errorCollection);
            return false;
        }
        return true;
    }

    boolean validateGroupIsNotInSelectedGroups(JiraServiceContext jiraServiceContext, Collection<String> selectedGroupsNames, Group group) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        I18nHelper i18n = jiraServiceContext.getI18nBean();
        Collection groupsUserIsIn = CollectionUtils.intersection(this.getParentGroupNames(group), selectedGroupsNames);
        if (selectedGroupsNames.size() == 1 && groupsUserIsIn.size() == 1) {
            String groupName = (String)groupsUserIsIn.iterator().next();
            errorCollection.addErrorMessage(i18n.getText("admin.editnestedgroups.error.group.already.member.of.group", group.getName(), groupName));
        } else if (selectedGroupsNames.size() == groupsUserIsIn.size()) {
            errorCollection.addErrorMessage(i18n.getText("admin.editnestedgroups.error.group.already.member.of.all", group.getName()));
        }
        if (errorCollection.hasAnyErrors()) {
            jiraServiceContext.getErrorCollection().addErrorCollection((ErrorCollection)errorCollection);
            return false;
        }
        return true;
    }

    boolean isUserInGroups(ApplicationUser user, Set<String> groupNames) {
        HashSet<String> usersGroupNames = new HashSet<String>(this.getUserGroups(user));
        return CollectionUtils.intersection(usersGroupNames, groupNames).size() == groupNames.size();
    }

    boolean isGroupInGroups(Group child, Set<String> groupNames) {
        Collection<String> usersGroupNames = this.getParentGroupNames(child);
        return CollectionUtils.intersection(usersGroupNames, groupNames).size() == groupNames.size();
    }

    boolean isExternalUserManagementEnabled() {
        return !ComponentAccessor.getUserManager().hasGroupWritableDirectory();
    }

    boolean validateGroupNamesExist(Collection groupNames, ErrorCollection errorCollection, I18nHelper i18n) {
        SimpleErrorCollection myErrorCollection = new SimpleErrorCollection();
        for (Object groupName1 : groupNames) {
            String groupName = (String)groupName1;
            if (!this.isGroupNull(groupName)) continue;
            myErrorCollection.addErrorMessage(i18n.getText("admin.errors.groups.group.does.not.exist", groupName));
        }
        if (myErrorCollection.hasAnyErrors()) {
            errorCollection.addErrorCollection((ErrorCollection)myErrorCollection);
            return false;
        }
        return true;
    }

    boolean validateGroupNamesNotAdmin(Collection groupNames, ErrorCollection errorCollection, I18nHelper i18n) {
        SimpleErrorCollection myErrorCollection = new SimpleErrorCollection();
        HashSet dissallowedGroups = new HashSet();
        dissallowedGroups.addAll(this.globalPermissionManager.getGroupNames(44));
        dissallowedGroups.addAll(this.globalPermissionManager.getGroupNames(0));
        for (Object groupName1 : groupNames) {
            String groupName = (String)groupName1;
            if (!dissallowedGroups.contains(groupName)) continue;
            myErrorCollection.addErrorMessage(i18n.getText("admin.editnestedgroups.error.admin.group.not.supported", groupName));
        }
        if (myErrorCollection.hasAnyErrors()) {
            errorCollection.addErrorCollection((ErrorCollection)myErrorCollection);
            return false;
        }
        return true;
    }

    void updateCommentsAndWorklogs(ApplicationUser user, String groupName, String swapGroup) {
        this.commentManager.swapCommentGroupRestriction(groupName, swapGroup);
        this.worklogManager.swapWorklogGroupRestriction(groupName, swapGroup);
    }

    void clearIssueSecurityLevelCache() {
        try {
            this.issueSecurityLevelManager.clearUsersLevels();
        }
        catch (UnsupportedOperationException uoe) {
            log.debug("Unsupported operation was thrown when trying to clear the issue security level manager cache", (Throwable)uoe);
        }
    }

    List<String> getGroupNamesUserCanSee(ApplicationUser currentUser) {
        List<String> allGroupNames = this.getAllGroupNames();
        return this.globalPermissionGroupAssociationUtil.getGroupNamesModifiableByCurrentUser(currentUser, allGroupNames);
    }

    void validateJiraServiceContext(JiraServiceContext jiraServiceContext) {
        if (jiraServiceContext == null) {
            throw new IllegalArgumentException("The JiraServiceContext must not be null.");
        }
        if (jiraServiceContext.getErrorCollection() == null) {
            throw new IllegalArgumentException("The error collection must not be null.");
        }
    }

    Collection<Group> convertGroupNamesToGroups(Collection<String> groupNames) {
        ArrayList groups = Lists.newArrayListWithCapacity((int)groupNames.size());
        for (String groupName : groupNames) {
            groups.add(this.getGroup(groupName));
        }
        return groups;
    }

    @VisibleForTesting
    boolean canActivateUsers(Collection<String> userNames) {
        Set<String> groupsThatGrantsUserAccess = this.getGroupsThatGrantsUserAccess();
        int usersToGainAccess = 0;
        for (String userName : userNames) {
            Set<String> userGroupNames = this.getGroupNamesForUserFromCrowd(userName);
            if (CollectionUtils.containsAny(userGroupNames, groupsThatGrantsUserAccess)) continue;
            ++usersToGainAccess;
        }
        return this.userUtil.canActivateNumberOfUsers(usersToGainAccess);
    }

    @VisibleForTesting
    boolean doesAnyGroupGrantUserAccessToJira(@Nonnull Collection groupsToJoin) {
        return this.getGroupsThatGrantsUserAccess().stream().anyMatch(groupsToJoin::contains);
    }

    private Set<String> getGroupsThatGrantsUserAccess() {
        assert (!this.applicationRoleManager.rolesEnabled());
        HashSet groupsThatGrantsUserAccess = new HashSet(this.globalPermissionManager.getGroupNamesWithPermission(GlobalPermissionKey.USE));
        groupsThatGrantsUserAccess.addAll(this.globalPermissionManager.getGroupNamesWithPermission(GlobalPermissionKey.ADMINISTER));
        groupsThatGrantsUserAccess.addAll(this.globalPermissionManager.getGroupNamesWithPermission(GlobalPermissionKey.SYSTEM_ADMIN));
        return Collections.unmodifiableSet(groupsThatGrantsUserAccess);
    }

    public Collection<String> getChildGroupNames(Group group) {
        MembershipQuery membershipQuery = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).childrenOf(EntityDescriptor.group()).withName(group.getName()).returningAtMost(-1);
        TreeSet<String> setOfGroups = new TreeSet<String>();
        Iterable children = this.crowdService.search((Query)membershipQuery);
        for (Group child : children) {
            if (!this.crowdService.isGroupDirectGroupMember(child, group)) continue;
            setOfGroups.add(child.getName());
        }
        return Collections.unmodifiableSortedSet(setOfGroups);
    }

    public Collection<String> getParentGroupNames(Group group) {
        MembershipQuery membershipQuery = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.group()).withName(group.getName()).returningAtMost(-1);
        TreeSet<String> setOfGroups = new TreeSet<String>();
        Iterable parents = this.crowdService.search((Query)membershipQuery);
        for (Group parent : parents) {
            if (!this.crowdService.isGroupDirectGroupMember(group, parent)) continue;
            setOfGroups.add(parent.getName());
        }
        return Collections.unmodifiableSortedSet(setOfGroups);
    }

    private Set<String> getGroupNamesForUserFromCrowd(String userName) {
        Iterable<Group> groupsForUserFromCrowd = this.getGroupsForUserFromCrowd(userName);
        if (groupsForUserFromCrowd == null || Iterables.isEmpty(groupsForUserFromCrowd)) {
            return ImmutableSet.of();
        }
        return (Set)Lists.newArrayList(groupsForUserFromCrowd).stream().map(Group::getName).collect(CollectorsUtil.toImmutableSet());
    }

    private Iterable<Group> getGroupsForUserFromCrowd(String userName) {
        MembershipQuery membershipQuery = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(userName).returningAtMost(-1);
        return this.crowdService.search((Query)membershipQuery);
    }

    boolean isUserInGroup(String groupName, ApplicationUser user) {
        return this.groupManager.isUserInGroup(user, groupName);
    }

    boolean isUserNull(ApplicationUser user) {
        return user == null;
    }

    List<String> getAllGroupNames() {
        return new ArrayList<String>(CollectionUtils.collect(this.getAllGroups(), (Transformer)GlobalPermissionGroupAssociationUtil.GROUP_TO_GROUPNAME));
    }

    Collection<String> getUserGroups(ApplicationUser user) {
        return this.groupManager.getGroupNamesForUser(user);
    }

    Collection<Group> getAllGroups() {
        return this.groupManager.getAllGroups();
    }

    boolean isGroupNull(String groupName) {
        return groupName == null || this.getGroup(groupName) == null;
    }

    void removeGroup(Group group) throws PermissionException {
        try {
            this.crowdService.removeGroup(group);
        }
        catch (OperationNotPermittedException e) {
            throw new PermissionException((Exception)((Object)e));
        }
    }

    Group getGroup(String groupName) {
        return groupName == null ? null : this.crowdService.getGroup(groupName);
    }

    ApplicationUser getUser(String userName) {
        return this.userUtil.getUser(userName);
    }
}

