/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.issue.events;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.analytics.api.annotations.PrivacyPolicySafe;

@PrivacyPolicySafe
public class WorkflowManualTransitionExecutionEvent {
    private static final String BASE_EVENT_NAME = "workflow.manual.issue.transition.execution";
    @PrivacyPolicySafe(value=false)
    private final String issueKey;
    @PrivacyPolicySafe(value=false)
    private final int actionId;
    private final boolean successful;

    public WorkflowManualTransitionExecutionEvent(String issueKey, int actionId, boolean successful) {
        this.issueKey = issueKey;
        this.actionId = actionId;
        this.successful = successful;
    }

    public String getIssueKey() {
        return this.issueKey;
    }

    public int getActionId() {
        return this.actionId;
    }

    @EventName
    public String buildEventName() {
        return String.format("%s.%s", BASE_EVENT_NAME, this.successful ? "successful" : "failed");
    }
}

