/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.user.search;

import com.atlassian.jira.bc.user.search.UserSearchUtilities;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.base.Predicate;
import org.apache.commons.lang.StringUtils;

public class UserMatcherPredicate
implements Predicate<ApplicationUser> {
    private final String query;
    private final boolean canMatchAddresses;
    private final String emailQuery;

    public UserMatcherPredicate(String query, boolean canMatchAddresses) {
        this(query, "", canMatchAddresses);
    }

    public UserMatcherPredicate(String nameQuery, String emailQuery, boolean canMatchAddresses) {
        Assertions.notNull((String)"query", (Object)nameQuery);
        Assertions.notNull((String)"emailquery", (Object)emailQuery);
        this.query = nameQuery.toLowerCase();
        this.emailQuery = emailQuery.toLowerCase();
        this.canMatchAddresses = canMatchAddresses;
    }

    public boolean apply(ApplicationUser user) {
        boolean separateEmailQuery = StringUtils.isNotBlank((String)this.emailQuery);
        java.util.function.Predicate<String> namePredicate = UserSearchUtilities.createUserMatchPredicate(this.query);
        java.util.function.Predicate<String> emailPredicate = separateEmailQuery ? UserSearchUtilities.createUserMatchPredicate(this.emailQuery) : namePredicate;
        boolean usernameMatched = false;
        String userPart = user.getName();
        if (StringUtils.isNotBlank((String)userPart) && namePredicate.test(userPart)) {
            if (separateEmailQuery && this.canMatchAddresses) {
                usernameMatched = true;
            } else {
                return true;
            }
        }
        if (this.canMatchAddresses) {
            userPart = user.getEmailAddress();
            if (StringUtils.isNotBlank((String)userPart) && emailPredicate.test(userPart)) {
                if (!separateEmailQuery || usernameMatched) {
                    return true;
                }
            } else if (separateEmailQuery) {
                return false;
            }
        }
        return StringUtils.isNotBlank((String)(userPart = user.getDisplayName())) && namePredicate.test(userPart);
    }
}

