/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bean;

import com.atlassian.jira.bean.SubTask;
import com.atlassian.jira.bean.SubTaskBean;
import com.atlassian.jira.bean.SubTaskImpl;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.web.bean.PercentageGraphModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.ofbiz.core.entity.GenericValue;

public class SubTaskBeanImpl
implements SubTaskBean {
    private List<SubTask> allSubTasks = new ArrayList<SubTask>();
    private List<SubTask> unresolvedSubTasks = new ArrayList<SubTask>();

    public void addSubTask(Long sequence, GenericValue subTaskIssue, GenericValue parentIssue) {
        SubTaskImpl subTask = new SubTaskImpl(sequence, subTaskIssue, parentIssue);
        this.allSubTasks.add(subTask);
        if (subTaskIssue.getString("resolution") == null) {
            this.unresolvedSubTasks.add(subTask);
        }
    }

    public void addSubTask(Long sequence, Issue subTaskIssue, Issue parentIssue) {
        SubTaskImpl subTask = new SubTaskImpl(sequence, subTaskIssue, parentIssue);
        this.allSubTasks.add(subTask);
        if (subTaskIssue.getResolutionId() == null) {
            this.unresolvedSubTasks.add(subTask);
        }
    }

    public Collection<SubTask> getSubTasks(String view) {
        return this.getSubTasksForView(view);
    }

    private List<SubTask> getSubTasksForView(String view) {
        if ("all".equals(view)) {
            return this.allSubTasks;
        }
        if ("unresolved".equals(view)) {
            return this.unresolvedSubTasks;
        }
        throw new IllegalArgumentException("Unknown sub-task view '" + view + "'.");
    }

    public Long getNextSequence(Long sequence, String view) {
        List<SubTask> subTaskList = this.getSubTasksForView(view);
        return this.findNextSequence(subTaskList, sequence);
    }

    public Long getPreviousSequence(Long sequence, String view) {
        ArrayList<SubTask> subTaskList = new ArrayList<SubTask>(this.getSubTasksForView(view));
        Collections.reverse(subTaskList);
        return this.findNextSequence(subTaskList, sequence);
    }

    private Long findNextSequence(List<SubTask> subTaskList, Long sequence) {
        Iterator<SubTask> iterator = subTaskList.iterator();
        while (iterator.hasNext()) {
            SubTask subTask = iterator.next();
            if (!subTask.getSequence().equals(sequence)) continue;
            if (iterator.hasNext()) {
                return iterator.next().getSequence();
            }
            throw new IllegalArgumentException("Trying to retrieve sequence for 'edge' sub-task.");
        }
        throw new IllegalArgumentException("Cannot find SubTaks with sequence '" + sequence + "'.");
    }

    public PercentageGraphModel getSubTaskProgress() {
        int numberOfUnresolvedSubTasks = this.unresolvedSubTasks.size();
        PercentageGraphModel model = new PercentageGraphModel();
        model.addRow("#51A825", (long)(this.allSubTasks.size() - numberOfUnresolvedSubTasks), "Resolved Sub-Tasks", null);
        model.addRow("#cccccc", (long)numberOfUnresolvedSubTasks, "Unresolved Sub-Tasks", null);
        return model;
    }
}

