/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bulkedit;

import com.atlassian.jira.bc.issue.watcher.WatcherService;
import com.atlassian.jira.bulkedit.BulkOperationManager;
import com.atlassian.jira.bulkedit.ProgressAwareBulkOperationWrapper;
import com.atlassian.jira.bulkedit.operation.BulkDeleteOperation;
import com.atlassian.jira.bulkedit.operation.BulkEditOperation;
import com.atlassian.jira.bulkedit.operation.BulkMigrateOperation;
import com.atlassian.jira.bulkedit.operation.BulkOperation;
import com.atlassian.jira.bulkedit.operation.BulkUnwatchOperation;
import com.atlassian.jira.bulkedit.operation.BulkWatchOperation;
import com.atlassian.jira.bulkedit.operation.BulkWorkflowTransitionOperation;
import com.atlassian.jira.bulkedit.operation.ProgressAwareBulkOperation;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.JiraUtils;
import com.atlassian.jira.util.collect.MapBuilder;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBulkOperationManager
implements BulkOperationManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultBulkOperationManager.class);
    private final WatcherService watcherService;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final Map<String, ProgressAwareBulkOperation> systemBulkOperations;
    private final Map<String, ProgressAwareBulkOperation> systemBulkWatchOperations;
    private final Map<String, ProgressAwareBulkOperation> pluginProvidedBulkOperations = Maps.newLinkedHashMap();

    public DefaultBulkOperationManager(JiraAuthenticationContext jiraAuthenticationContext, WatcherService watcherService, BulkEditOperation bulkEditOperation, BulkMigrateOperation bulkMigrateOperation, BulkWorkflowTransitionOperation bulkWorkflowTransitionOperation, BulkDeleteOperation bulkDeleteOperation, BulkWatchOperation bulkWatchOperation, BulkUnwatchOperation bulkUnwatchOperation) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.watcherService = watcherService;
        this.systemBulkOperations = ImmutableMap.of((Object)bulkEditOperation.getNameKey(), (Object)bulkEditOperation, (Object)bulkMigrateOperation.getNameKey(), (Object)bulkMigrateOperation, (Object)bulkWorkflowTransitionOperation.getNameKey(), (Object)bulkWorkflowTransitionOperation, (Object)bulkDeleteOperation.getNameKey(), (Object)bulkDeleteOperation);
        this.systemBulkWatchOperations = ImmutableMap.of((Object)bulkWatchOperation.getNameKey(), (Object)bulkWatchOperation, (Object)bulkUnwatchOperation.getNameKey(), (Object)bulkUnwatchOperation);
    }

    public Collection<BulkOperation> getBulkOperations() {
        ArrayList<BulkOperation> legacyBulkOperations = new ArrayList<BulkOperation>();
        for (ProgressAwareBulkOperation bulkOperation : this.getBulkOperationsMap().values()) {
            if (!(bulkOperation instanceof ProgressAwareBulkOperationWrapper)) continue;
            legacyBulkOperations.add(((ProgressAwareBulkOperationWrapper)bulkOperation).getLegacyBulkOperation());
        }
        return legacyBulkOperations;
    }

    public Collection<ProgressAwareBulkOperation> getProgressAwareBulkOperations() {
        return this.getBulkOperationsMap().values();
    }

    public BulkOperation getOperation(String operationName) {
        ProgressAwareBulkOperation bulkOperation = this.getBulkOperationsMap().get(operationName);
        if (bulkOperation instanceof ProgressAwareBulkOperationWrapper) {
            return ((ProgressAwareBulkOperationWrapper)bulkOperation).getLegacyBulkOperation();
        }
        return null;
    }

    public ProgressAwareBulkOperation getProgressAwareOperation(String operationName) {
        return this.getBulkOperationsMap().get(operationName);
    }

    public boolean isValidOperation(String operationName) {
        return this.getBulkOperationsMap().containsKey(operationName);
    }

    public void addBulkOperation(String operationName, Class<? extends BulkOperation> componentClass) {
        if (log.isDebugEnabled()) {
            log.debug("Adding Bulk Operation " + operationName + " with class " + componentClass);
        }
        BulkOperation legacyBulkOperation = JiraUtils.loadComponent(componentClass);
        this.pluginProvidedBulkOperations.put(operationName, new ProgressAwareBulkOperationWrapper(legacyBulkOperation));
    }

    public void addProgressAwareBulkOperation(String operationName, Class<? extends ProgressAwareBulkOperation> componentClass) {
        if (log.isDebugEnabled()) {
            log.debug("Adding Bulk Operation " + operationName + " with class " + componentClass);
        }
        this.pluginProvidedBulkOperations.put(operationName, JiraUtils.loadComponent(componentClass));
    }

    protected Map<String, ProgressAwareBulkOperation> getBulkOperationsMap() {
        MapBuilder results = MapBuilder.newBuilder();
        results.addAll(this.systemBulkOperations);
        if (this.jiraAuthenticationContext.isLoggedInUser() && this.watcherService.isWatchingEnabled()) {
            results.addAll(this.systemBulkWatchOperations);
        }
        results.addAll(this.pluginProvidedBulkOperations);
        return results.toListOrderedMap();
    }
}

