/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.charts;

import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.charts.Chart;
import com.atlassian.jira.charts.jfreechart.ChartHelper;
import com.atlassian.jira.charts.jfreechart.PieChartGenerator;
import com.atlassian.jira.charts.piechart.PieChartDataSetFactory;
import com.atlassian.jira.charts.piechart.PieChartUrlGeneratorFactory;
import com.atlassian.jira.charts.util.ChartUtils;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.customfields.statistics.CustomFieldStattable;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.SearchRequestAppender;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.bean.I18nBean;
import com.atlassian.jira.web.bean.StatisticAccessorBean;
import com.atlassian.jira.web.bean.StatisticMap;
import com.atlassian.jira.web.bean.StatisticMapWrapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.jfree.chart.labels.PieToolTipGenerator;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.urls.CategoryURLGenerator;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.PieDataset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PieChart {
    private static final Logger log = LoggerFactory.getLogger(PieChart.class);
    static final String ISSUES_MESSAGE_CODE = "datacollector.tooltip.issues";
    private final ConstantsManager constantsManager;
    private final CustomFieldManager customFieldManager;
    private final SearchService searchService;
    private final ApplicationProperties applicationProperties;
    private final Comparable otherSegmentKey = "Other";

    public PieChart(ConstantsManager constantsManager, CustomFieldManager customFieldManager, SearchService searchService, ApplicationProperties applicationProperties) {
        this.constantsManager = constantsManager;
        this.customFieldManager = customFieldManager;
        this.searchService = searchService;
        this.applicationProperties = applicationProperties;
    }

    public Chart generateChart(ApplicationUser remoteUser, SearchRequest searchRequest, String statisticType, int desiredChartWidth, int desiredChartHeight) {
        return this.generateChartInternal(remoteUser, searchRequest, statisticType, desiredChartWidth, desiredChartHeight, false);
    }

    public Chart generateInlineChart(ApplicationUser remoteUser, SearchRequest searchRequest, String statisticType, int desiredChartWidth, int desiredChartHeight) {
        return this.generateChartInternal(remoteUser, searchRequest, statisticType, desiredChartWidth, desiredChartHeight, true);
    }

    private Chart generateChartInternal(ApplicationUser remoteUser, SearchRequest searchRequest, String statisticType, int desiredChartWidth, int desiredChartHeight, boolean inline) {
        Assertions.notNull((String)"searchRequest", (Object)searchRequest);
        Assertions.notNull((String)"statisticType", (Object)statisticType);
        I18nBean i18nBean = PieChart.getI18nBean(remoteUser);
        try {
            log.debug("DataCollector.populatePieChart: Cloning the SearchRequest.");
            SearchRequest clonedSearchRequest = new SearchRequest(searchRequest.getQuery());
            StatisticAccessorBean statisticAccessor = new StatisticAccessorBean(remoteUser, clonedSearchRequest);
            StatisticMapWrapper statisticMapWrapper = statisticAccessor.getAllFilterBy(statisticType);
            SearchRequestAppender searchRequestAppender = statisticAccessor.getSearchRequestAppender(statisticType);
            PieChartDataSetFactory dataSetFactory = new PieChartDataSetFactory(this.constantsManager, this.customFieldManager, (StatisticMap<?, Number>)statisticMapWrapper, i18nBean, statisticType);
            long numIssues = statisticMapWrapper.getTotalCount();
            PieDataset sortedDataset = dataSetFactory.createSortedPieDataset();
            PieDataset consolidatedDataset = dataSetFactory.createConsolidatedPieDataset(sortedDataset, this.otherSegmentKey);
            CategoryDataset categoryDataset = dataSetFactory.createCategoryDataset(numIssues, sortedDataset);
            log.debug("DataCollector.populatePieChart: Generate the ChartHelper.");
            ChartHelper helper = new PieChartGenerator(consolidatedDataset, (I18nHelper)i18nBean).generateChart();
            log.debug("DataCollector.populatePieChart: ChartHelper generated. Add Tooltips and URL Generators.");
            PieChartUrlGeneratorFactory urlGeneratorFactory = new PieChartUrlGeneratorFactory(this.searchService, this.applicationProperties, searchRequestAppender, remoteUser, clonedSearchRequest);
            PiePlot plot = (PiePlot)helper.getChart().getPlot();
            plot.setToolTipGenerator(PieChart.createPieToolTipGenerator(i18nBean, numIssues));
            plot.setURLGenerator(urlGeneratorFactory.getPieUrlGenerator(this.otherSegmentKey));
            int chartHeight = numIssues == 0L ? 35 : desiredChartHeight;
            int chartWidth = desiredChartWidth;
            log.debug("DataCollector.populatePieChart: Have the ChartHelper generate the image.");
            if (inline) {
                helper.generateInline(chartWidth, chartHeight);
            } else {
                helper.generate(chartWidth, chartHeight);
            }
            log.debug("DataCollector.populatePieChart: ChartHelper finished generating.");
            Map<String, Object> params = this.createChartParameters(statisticType, i18nBean, numIssues, consolidatedDataset, categoryDataset, helper, urlGeneratorFactory.getCategoryUrlGenerator(), chartHeight, chartWidth);
            if (inline) {
                String base64Image = ((ChartUtils)ComponentAccessor.getComponent(ChartUtils.class)).renderBase64Chart(helper.getImage(), "Pie Chart");
                params.put("base64Image", base64Image);
            }
            return new Chart(helper.getLocation(), helper.getImageMapHtml(), helper.getImageMapName(), params);
        }
        catch (SearchException e) {
            throw new RuntimeException("Error generating pie chart", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Error generating pie chart", e);
        }
    }

    private Map<String, Object> createChartParameters(String statisticType, I18nBean i18nBean, long numIssues, PieDataset consolidatedDataset, CategoryDataset completeDataset, ChartHelper helper, CategoryURLGenerator completeUrlGenerator, int chartHeight, int chartWidth) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("chart", helper.getLocation());
        params.put("chartDataset", consolidatedDataset);
        params.put("completeDataset", completeDataset);
        params.put("completeDatasetUrlGenerator", completeUrlGenerator);
        params.put("numIssues", numIssues);
        params.put("statisticType", statisticType);
        params.put("statisticTypeI18nName", this.getStatisticsTypeI18nName(i18nBean, statisticType));
        params.put("imagemap_html", helper.getImageMapHtml());
        params.put("imagemapName", helper.getImageMapName());
        params.put("width", chartWidth);
        params.put("height", chartHeight);
        return params;
    }

    static PieToolTipGenerator createPieToolTipGenerator(final I18nBean i18nBean, final long numIssues) {
        return new PieToolTipGenerator(){

            public String generateToolTip(PieDataset dataset, Comparable key) {
                Number number = dataset.getValue(key);
                return key + ": " + number + " " + i18nBean.getText(PieChart.ISSUES_MESSAGE_CODE) + " (" + (long)(100 * number.intValue()) / numIssues + "%)";
            }
        };
    }

    String getStatisticsTypeI18nName(I18nHelper i18nBean, String statisticType) {
        if (statisticType.startsWith("customfield_")) {
            CustomField customField = this.customFieldManager.getCustomFieldObject(statisticType);
            if (customField == null) {
                throw new RuntimeException("No custom field with id '" + statisticType + "'");
            }
            if (customField.getCustomFieldSearcher() instanceof CustomFieldStattable) {
                return customField.getName();
            }
            return null;
        }
        return i18nBean.getText("gadget.filterstats.field.statistictype." + statisticType.toLowerCase());
    }

    private static I18nBean getI18nBean(ApplicationUser remoteUser) {
        return new I18nBean(remoteUser);
    }
}

