/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.charts.util;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.charts.util.ChartUtils;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.Base64InputStreamConsumer;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jfree.chart.encoders.EncoderUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChartUtilsImpl
implements ChartUtils {
    private static final Logger log = LoggerFactory.getLogger(ChartUtilsImpl.class);
    private final JiraAuthenticationContext authenticationContext;
    private final ProjectManager projectManager;
    private final SearchService searchService;
    private final SearchRequestService searchRequestService;
    private final JiraHome jiraHome;

    public ChartUtilsImpl(SearchRequestService searchRequestService, JiraAuthenticationContext authenticationContext, ProjectManager projectManager, SearchService searchService, JiraHome jiraHome) {
        this.searchRequestService = searchRequestService;
        this.authenticationContext = authenticationContext;
        this.projectManager = projectManager;
        this.searchService = searchService;
        this.jiraHome = jiraHome;
    }

    public SearchRequest retrieveOrMakeSearchRequest(String projectOrFilterId, Map<String, Object> params) {
        SearchRequest sr = null;
        ApplicationUser user = this.authenticationContext.getUser();
        if (projectOrFilterId.startsWith("filter-")) {
            Long filterId = new Long(projectOrFilterId.substring(7));
            sr = this.searchRequestService.getFilter((JiraServiceContext)new JiraServiceContextImpl(user, (ErrorCollection)new SimpleErrorCollection()), filterId);
            if (sr != null) {
                params.put("searchRequest", sr);
            }
        } else if (projectOrFilterId.startsWith("project-")) {
            Long projectId = new Long(projectOrFilterId.substring(8));
            Project project = this.projectManager.getProjectObj(projectId);
            if (project != null) {
                sr = this.makeProjectSearchRequest(project.getKey());
                params.put("project", project);
            }
        } else if (projectOrFilterId.startsWith("jql-")) {
            String jql = projectOrFilterId.substring(4);
            sr = new SearchRequest();
            if (StringUtils.isNotBlank((String)jql)) {
                SearchService.ParseResult parseResult = this.searchService.parseQuery(user, jql);
                if (parseResult.isValid()) {
                    sr = new SearchRequest(parseResult.getQuery());
                } else {
                    throw new IllegalArgumentException("Invalid JQL query specified for chart '" + jql + "'.");
                }
            }
            params.put("searchRequest", sr);
        }
        return sr;
    }

    private SearchRequest makeProjectSearchRequest(String projectKey) {
        return new SearchRequest(JqlQueryBuilder.newBuilder().where().project(new String[]{projectKey}).buildQuery());
    }

    public File getChartDirectory() {
        File tempDirectory = new File(this.jiraHome.getSharedCachesDirectory(), "charts");
        if (!tempDirectory.exists()) {
            tempDirectory.mkdir();
        }
        return tempDirectory;
    }

    public String renderBase64Chart(BufferedImage image, String chartName) {
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(EncoderUtil.encode((BufferedImage)image, (String)"png"));
            Base64InputStreamConsumer base64Consumer = new Base64InputStreamConsumer(false);
            base64Consumer.consume(inputStream);
            return "data:image/png;base64," + base64Consumer.getEncoded();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to base 64 chart image with name " + chartName, e);
        }
    }
}

