/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.logging;

import com.atlassian.jira.cluster.ClusterMessageConsumer;
import com.atlassian.jira.cluster.Message;
import com.atlassian.jira.cluster.MessageHandlerService;
import com.atlassian.jira.cluster.logging.LoggingManager;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.util.log.LogMarker;
import com.atlassian.util.concurrent.Assertions;
import com.atlassian.util.profiling.UtilTimerStack;
import javax.annotation.Nonnull;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class ClusterLoggingManager
implements LoggingManager,
Startable {
    private static final String CHANNEL_LEVEL = "Log Level";
    private static final String CHANNEL_MARK = "Log Mark";
    private static final String CHANNEL_PROFILE = "Profile";
    private final MessageHandlerService messageHandlerService;
    private final JiraProperties jiraSystemProperties;
    private final LoggingMessageConsumer messageConsumer = new LoggingMessageConsumer();

    public ClusterLoggingManager(MessageHandlerService messageHandlerService, JiraProperties jiraSystemProperties) {
        this.messageHandlerService = messageHandlerService;
        this.jiraSystemProperties = jiraSystemProperties;
    }

    public void start() throws Exception {
        this.messageHandlerService.registerListener(CHANNEL_LEVEL, this.messageConsumer);
        this.messageHandlerService.registerListener(CHANNEL_MARK, this.messageConsumer);
        this.messageHandlerService.registerListener(CHANNEL_PROFILE, this.messageConsumer);
    }

    @Override
    public void setLogLevel(@Nonnull String loggerName, @Nonnull String levelName) {
        Assertions.notNull((String)"loggerName", (Object)loggerName);
        Assertions.notNull((String)"levelName", (Object)levelName);
        ClusterLoggingManager.getLogger(loggerName).setLevel(Level.toLevel((String)levelName));
        this.messageHandlerService.sendMessage("ALL", new Message(CHANNEL_LEVEL, this.serializeAsString(loggerName, levelName)));
    }

    @Override
    public void setLogLevel(@Nonnull Logger logger, @Nonnull Level level) {
        Assertions.notNull((String)"logger", (Object)logger);
        Assertions.notNull((String)"level", (Object)level);
        logger.setLevel(level);
        this.messageHandlerService.sendMessage("ALL", new Message(CHANNEL_LEVEL, this.serializeAsString(logger.getName(), level.toString())));
    }

    @Override
    public void markLogs(String msg, boolean rollOver) {
        ClusterLoggingManager.mark(msg, rollOver);
        this.messageHandlerService.sendMessage("ALL", new Message(CHANNEL_MARK, this.serializeAsString(msg, String.valueOf(rollOver))));
    }

    @Override
    public void enableProfiling() {
        this.jiraSystemProperties.setProperty("atlassian.profile.mintime", (Object)"1");
        UtilTimerStack.setActive((boolean)true);
        this.messageHandlerService.sendMessage("ALL", new Message(CHANNEL_PROFILE, String.valueOf(true)));
    }

    @Override
    public void disableProfiling() {
        UtilTimerStack.setActive((boolean)false);
        this.messageHandlerService.sendMessage("ALL", new Message(CHANNEL_PROFILE, String.valueOf(false)));
    }

    private static void mark(String msg, boolean rollOver) {
        if (rollOver) {
            LogMarker.rolloverAndMark(msg);
        } else {
            LogMarker.markLogs(msg);
        }
    }

    private static Logger getLogger(String loggerName) {
        return "root".equals(loggerName) ? Logger.getRootLogger() : Logger.getLogger((String)loggerName);
    }

    private String serializeAsString(String logger, String levelName) {
        return logger + "-" + levelName;
    }

    class LoggingMessageConsumer
    implements ClusterMessageConsumer {
        LoggingMessageConsumer() {
        }

        public void receive(String channel, String message, String senderId) {
            if (channel.equals(ClusterLoggingManager.CHANNEL_LEVEL)) {
                ClusterLoggingManager.getLogger(this.getLoggerFromMessageInfo(message)).setLevel(Level.toLevel((String)this.getLevelFromMessageInfo(message)));
            }
            if (channel.equals(ClusterLoggingManager.CHANNEL_MARK)) {
                ClusterLoggingManager.mark(this.getMarkFromMessageInfo(message), this.getRolloverFromMessageInfo(message));
            }
            if (channel.equals(ClusterLoggingManager.CHANNEL_PROFILE)) {
                this.setProfiling(message);
            }
        }

        private void setProfiling(String message) {
            boolean active = Boolean.valueOf(message);
            if (active) {
                ClusterLoggingManager.this.jiraSystemProperties.setProperty("atlassian.profile.mintime", (Object)"1");
            }
            UtilTimerStack.setActive((boolean)active);
        }

        private String getLoggerFromMessageInfo(String messageInfo) {
            return messageInfo.substring(0, messageInfo.lastIndexOf(45));
        }

        private String getLevelFromMessageInfo(String messageInfo) {
            return messageInfo.substring(messageInfo.lastIndexOf("-") + 1);
        }

        private String getMarkFromMessageInfo(String messageInfo) {
            return messageInfo.substring(0, messageInfo.lastIndexOf(45));
        }

        private boolean getRolloverFromMessageInfo(String messageInfo) {
            return Boolean.valueOf(messageInfo.substring(messageInfo.lastIndexOf("-") + 1));
        }
    }
}

