/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.util;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.PropertiesUtil;
import com.atlassian.jira.util.dbc.Assertions;

public interface IndexingConfiguration {
    public int getIndexLockWaitTime();

    public int getMaxReindexes();

    public int getIssuesToForceOptimize();

    public boolean isIndexAvailable();

    public void disableIndex();

    public void enableIndex();

    public static class PropertiesAdapter
    implements IndexingConfiguration {
        private volatile boolean indexAvailable = true;
        private final ApplicationProperties applicationProperties;

        public PropertiesAdapter(ApplicationProperties applicationProperties) {
            this.applicationProperties = (ApplicationProperties)Assertions.notNull((String)"applicationProperties", (Object)applicationProperties);
        }

        @Override
        public int getIndexLockWaitTime() {
            return PropertiesUtil.getIntProperty((ApplicationProperties)this.applicationProperties, (String)"jira.index.lock.waittime", (int)30000);
        }

        @Override
        public int getMaxReindexes() {
            return PropertiesUtil.getIntProperty((ApplicationProperties)this.applicationProperties, (String)"jira.index.max.reindexes", (int)4000);
        }

        @Override
        public int getIssuesToForceOptimize() {
            return PropertiesUtil.getIntProperty((ApplicationProperties)this.applicationProperties, (String)"jira.index.update.bulk.optimization", (int)400);
        }

        @Override
        public boolean isIndexAvailable() {
            return this.indexAvailable;
        }

        @Override
        public void enableIndex() {
            this.indexAvailable = true;
        }

        @Override
        public void disableIndex() {
            this.indexAvailable = false;
        }

        private static final class Defaults {
            private static final int MAX_REINDEXES = 4000;
            private static final int INDEX_LOCK_WAIT_TIME = 30000;
            private static final int ISSUES_TO_FORCE_OPTIMIZE = 400;

            private Defaults() {
            }
        }
    }
}

