/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.diagnostic;

import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.web.monitor.dump.Dumper;
import com.atlassian.jira.web.monitor.dump.HeapDumper;
import com.atlassian.plugin.IllegalPluginStateException;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.event.events.PluginContainerFailedEvent;
import com.atlassian.plugin.osgi.event.PluginServiceDependencyWaitTimedOutEvent;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginDiagnostics {
    private static final Logger log = LoggerFactory.getLogger(PluginDiagnostics.class);
    public static final String HEAP_DUMP_FILE = "jira.heap.dump.location";

    public PluginDiagnostics(PluginEventManager pluginEventManager, JiraProperties jiraSystemProperties) {
        if (jiraSystemProperties.isDevMode() || jiraSystemProperties.getBoolean("jira.dump").booleanValue()) {
            log.warn("Registering PluginDiagnostics with the event manager.");
            pluginEventManager.register((Object)new DiagnosticListener(jiraSystemProperties));
        }
    }

    public static class DiagnosticListener {
        private final AtomicBoolean dumped = new AtomicBoolean();
        private final JiraProperties jiraSystemProperties;

        public DiagnosticListener(JiraProperties jiraSystemProperties) {
            this.jiraSystemProperties = jiraSystemProperties;
        }

        @PluginEventListener
        public void onSpringContextFailed(PluginContainerFailedEvent event) throws IllegalPluginStateException {
            this.dump(String.format("Plugin %s failed", event.getPluginKey()));
        }

        @PluginEventListener
        public void onDependencyTimedOut(PluginServiceDependencyWaitTimedOutEvent timedOutEvent) {
            this.dump(String.format("Service dependency in plugin %s on %s timed out after %d", timedOutEvent.getPluginKey(), timedOutEvent.getBeanName(), timedOutEvent.getElapsedTime()));
        }

        private void dump(String reason) {
            if (this.dumped.compareAndSet(false, true)) {
                log.warn("Creating a thread and heap dump because {}", (Object)reason);
                new Dumper().dumpThreads(null);
                HeapDumper.dumpHeap(this.jiraSystemProperties.getProperty(PluginDiagnostics.HEAP_DUMP_FILE, "jira-heap-dump.hprof"), true);
            }
        }
    }
}

