/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.help;

import com.atlassian.application.api.ApplicationKey;
import com.atlassian.jira.help.HelpUrl;
import com.atlassian.jira.help.HelpUrls;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

class ImmutableHelpUrls
implements HelpUrls {
    private final Map<String, HelpUrl> urls;
    private final HelpUrl defaultUrl;

    ImmutableHelpUrls(HelpUrl defaultUrl, Iterable<? extends HelpUrl> urls) {
        Assertions.notNull(urls);
        this.defaultUrl = (HelpUrl)Assertions.notNull((Object)defaultUrl);
        HashMap index = Maps.newHashMap();
        for (HelpUrl helpUrl : urls) {
            index.put(helpUrl.getKey(), helpUrl);
        }
        index.put(defaultUrl.getKey(), defaultUrl);
        this.urls = ImmutableMap.copyOf((Map)index);
    }

    @Nonnull
    public HelpUrl getUrl(@Nonnull String key) {
        HelpUrl helpUrl = this.urls.get(Assertions.notNull((String)"key", (Object)key));
        return helpUrl == null ? this.defaultUrl : helpUrl;
    }

    @Nonnull
    public HelpUrl getDefaultUrl() {
        return this.defaultUrl;
    }

    @Nonnull
    public Set<String> getUrlKeys() {
        return this.urls.keySet();
    }

    @Nonnull
    public HelpUrl getUrlForApplication(@Nonnull ApplicationKey applicationKey, @Nonnull String key) {
        return this.getUrl(key);
    }

    public Iterator<HelpUrl> iterator() {
        return this.urls.values().iterator();
    }

    @Nonnull
    public static ImmutableHelpUrls merge(@Nonnull ImmutableHelpUrls first, @Nonnull ImmutableHelpUrls second) {
        return new ImmutableHelpUrls(first.getDefaultUrl(), Iterables.concat(first.urls.values(), second.urls.values()));
    }
}

