/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.core;

import com.atlassian.jira.imports.project.core.BackupSystemInformation;
import com.atlassian.jira.plugin.PluginVersion;
import com.atlassian.jira.util.dbc.Null;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BackupSystemInformationImpl
implements BackupSystemInformation {
    private final List<PluginVersion> pluginVersions;
    private final String buildNumber;
    private final String edition;
    private final boolean unassignedIssuesAllowed;
    private final Map<String, String> issueIdToKeyMap;
    private final Set<String> entities;
    private final int entityCount;

    public BackupSystemInformationImpl(String buildNumber, String edition, List<PluginVersion> pluginVersions, boolean unassignedIssuesAllowed, Map<String, String> issueIdToKeyMap, Set<String> entities, int entityCount) {
        Null.not("pluginVersions", pluginVersions);
        Null.not("entityNames", entities);
        this.buildNumber = buildNumber;
        this.edition = edition;
        this.pluginVersions = Collections.unmodifiableList(pluginVersions);
        this.unassignedIssuesAllowed = unassignedIssuesAllowed;
        this.issueIdToKeyMap = Collections.unmodifiableMap(issueIdToKeyMap);
        this.entities = entities;
        this.entityCount = entityCount;
    }

    public String getBuildNumber() {
        return this.buildNumber;
    }

    public String getEdition() {
        return this.edition;
    }

    public List<PluginVersion> getPluginVersions() {
        return this.pluginVersions;
    }

    public boolean unassignedIssuesAllowed() {
        return this.unassignedIssuesAllowed;
    }

    public String getIssueKeyForId(String issueId) {
        return this.issueIdToKeyMap.get(issueId);
    }

    public int getEntityCount() {
        return this.entityCount;
    }

    public Set<String> getEntityTypes() {
        return ImmutableSet.copyOf(this.entities);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n").append("PluginVersions: ").append("\n");
        Iterator<PluginVersion> iterator = this.pluginVersions.iterator();
        while (iterator.hasNext()) {
            PluginVersion pluginVersion1;
            PluginVersion pluginVersion = pluginVersion1 = iterator.next();
            sb.append("\n").append("     ").append(pluginVersion);
        }
        sb.append("\n");
        sb.append("JIRA Build #: ").append(this.getBuildNumber()).append("\n");
        sb.append("JIRA Edition: ").append(this.getEdition()).append("\n");
        sb.append("Allow unassigned issues: ").append(this.unassignedIssuesAllowed()).append("\n");
        return sb.toString();
    }
}

