/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.parser;

import com.atlassian.jira.exception.ParseException;
import com.atlassian.jira.external.beans.ExternalCustomField;
import com.atlassian.jira.imports.project.core.BackupOverviewBuilder;
import com.atlassian.jira.imports.project.parser.CustomFieldParser;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class CustomFieldParserImpl
implements CustomFieldParser {
    private static final String CUSTOM_FIELD_PREFIX = "customfield_";

    @Override
    public ExternalCustomField parseCustomField(Map attributes) throws ParseException {
        if (attributes == null) {
            throw new IllegalArgumentException("The 'attributes' parameter cannot be null.");
        }
        String id = (String)attributes.get("id");
        String name = (String)attributes.get("name");
        String customfieldtypekey = (String)attributes.get("customfieldtypekey");
        if (StringUtils.isEmpty((String)id)) {
            throw new ParseException("No 'id' field for CustomField.");
        }
        if (StringUtils.isEmpty((String)name)) {
            throw new ParseException("No 'name' field for CustomField " + id + ".");
        }
        if (StringUtils.isEmpty((String)customfieldtypekey)) {
            throw new ParseException("No 'customfieldtypekey' field for CustomField " + id + ".");
        }
        return new ExternalCustomField(id, name, customfieldtypekey);
    }

    @Override
    public BackupOverviewBuilder.ConfigurationContext parseCustomFieldConfiguration(Map attributes) throws ParseException {
        if (attributes == null) {
            throw new IllegalArgumentException("The 'attributes' parameter cannot be null.");
        }
        String id = (String)attributes.get("id");
        String projectId = (String)attributes.get("project");
        String customFieldId = (String)attributes.get("key");
        String fieldconfigscheme = (String)attributes.get("fieldconfigscheme");
        if (StringUtils.isEmpty((String)id)) {
            throw new ParseException("No 'id' field for ConfigurationContext.");
        }
        if (StringUtils.isEmpty((String)customFieldId)) {
            throw new ParseException("No 'key' field for ConfigurationContext " + id + ".");
        }
        if (!customFieldId.startsWith(CUSTOM_FIELD_PREFIX)) {
            return null;
        }
        customFieldId = customFieldId.substring(CUSTOM_FIELD_PREFIX.length());
        if (StringUtils.isEmpty((String)fieldconfigscheme)) {
            throw new ParseException("No 'fieldconfigscheme' field for ConfigurationContext " + id + ".");
        }
        return new BackupOverviewBuilder.ConfigurationContext(fieldconfigscheme, customFieldId, projectId);
    }

    @Override
    public BackupOverviewBuilder.FieldConfigSchemeIssueType parseFieldConfigSchemeIssueType(Map attributes) throws ParseException {
        if (attributes == null) {
            throw new IllegalArgumentException("The 'attributes' parameter cannot be null.");
        }
        String id = (String)attributes.get("id");
        if (StringUtils.isEmpty((String)id)) {
            throw new ParseException("No 'id' field for FieldConfigSchemeIssueType.");
        }
        String fieldconfigscheme = (String)attributes.get("fieldconfigscheme");
        if (StringUtils.isEmpty((String)fieldconfigscheme)) {
            throw new ParseException("No 'fieldconfigscheme' field for FieldConfigSchemeIssueType.");
        }
        String issuetype = (String)attributes.get("issuetype");
        return new BackupOverviewBuilder.FieldConfigSchemeIssueType(fieldconfigscheme, issuetype);
    }
}

