/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.parser;

import com.atlassian.jira.exception.ParseException;
import com.atlassian.jira.imports.project.parser.PluginVersionParser;
import com.atlassian.jira.plugin.PluginVersion;
import com.atlassian.jira.plugin.PluginVersionImpl;
import com.atlassian.jira.util.dbc.Null;
import java.sql.Timestamp;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class PluginVersionParserImpl
implements PluginVersionParser {
    @Override
    public PluginVersion parse(Map attributes) throws ParseException {
        Null.not("The 'attributes' parameter cannot be null.", attributes);
        String idStr = (String)attributes.get("id");
        String name = (String)attributes.get("name");
        String key = (String)attributes.get("key");
        String version = (String)attributes.get("version");
        String created = (String)attributes.get("created");
        if (StringUtils.isEmpty((String)idStr)) {
            throw new ParseException("No 'id' field for PluginVersion.");
        }
        Long id = null;
        try {
            id = new Long(idStr);
        }
        catch (NumberFormatException e) {
            throw new ParseException("Unable to parse the id '" + idStr + "' into a long.");
        }
        if (StringUtils.isEmpty((String)name)) {
            throw new ParseException("No 'name' field for PluginVersion " + id + ".");
        }
        if (StringUtils.isEmpty((String)key)) {
            throw new ParseException("No 'key' field for PluginVersion " + id + ".");
        }
        if (StringUtils.isEmpty((String)version)) {
            throw new ParseException("No 'version' field for PluginVersion " + id + ".");
        }
        Timestamp createdDate = null;
        if (created != null) {
            createdDate = Timestamp.valueOf(created);
        }
        return new PluginVersionImpl(id, key, name, version, createdDate);
    }
}

