/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.transformer;

import com.atlassian.jira.external.beans.ExternalLink;
import com.atlassian.jira.imports.project.core.BackupSystemInformation;
import com.atlassian.jira.imports.project.mapper.ProjectImportMapper;
import com.atlassian.jira.imports.project.transformer.IssueLinkTransformer;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;

public class IssueLinkTransformerImpl
implements IssueLinkTransformer {
    private final IssueManager issueManager;
    private final BackupSystemInformation backupSystemInformation;

    public IssueLinkTransformerImpl(IssueManager issueManager, BackupSystemInformation backupSystemInformation) {
        this.issueManager = issueManager;
        this.backupSystemInformation = backupSystemInformation;
    }

    @Override
    public ExternalLink transform(ProjectImportMapper projectImportMapper, ExternalLink oldIssueLink) {
        String newSourceID = this.getNewIssueID(oldIssueLink.getSourceId(), projectImportMapper);
        if (newSourceID == null) {
            return null;
        }
        String newDestinationID = this.getNewIssueID(oldIssueLink.getDestinationId(), projectImportMapper);
        if (newDestinationID == null) {
            return null;
        }
        ExternalLink newLink = new ExternalLink();
        newLink.setLinkType(projectImportMapper.getIssueLinkTypeMapper().getMappedId(oldIssueLink.getLinkType()));
        newLink.setSourceId(newSourceID);
        newLink.setDestinationId(newDestinationID);
        newLink.setSequence(oldIssueLink.getSequence());
        return newLink;
    }

    private String getNewIssueID(String oldIssueId, ProjectImportMapper projectImportMapper) {
        String newIssueId = projectImportMapper.getIssueMapper().getMappedId(oldIssueId);
        if (newIssueId != null) {
            return newIssueId;
        }
        String key = this.backupSystemInformation.getIssueKeyForId(oldIssueId);
        if (key == null) {
            return null;
        }
        MutableIssue issue = this.issueManager.getIssueObject(key);
        if (issue == null) {
            return null;
        }
        return issue.getId().toString();
    }
}

