/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.validation;

import com.atlassian.jira.imports.project.core.BackupProject;
import com.atlassian.jira.issue.fields.TextFieldCharacterLengthValidator;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.MessageSetImpl;

public class SystemFieldsMaxTextLengthValidator {
    private final TextFieldCharacterLengthValidator textFieldCharacterLengthValidator;

    public SystemFieldsMaxTextLengthValidator(TextFieldCharacterLengthValidator textFieldCharacterLengthValidator) {
        this.textFieldCharacterLengthValidator = textFieldCharacterLengthValidator;
    }

    public MessageSet validate(BackupProject backupProject, I18nHelper i18nHelper) {
        MessageSetImpl messageSet = new MessageSetImpl();
        int maxTextFieldLength = backupProject.getSystemFieldMaxTextLength();
        if (this.textFieldCharacterLengthValidator.isTextTooLong(maxTextFieldLength)) {
            messageSet.addErrorMessage(i18nHelper.getText("admin.errors.project.import.field.text.too.long", String.valueOf(maxTextFieldLength), String.valueOf(this.textFieldCharacterLengthValidator.getMaximumNumberOfCharacters())));
        }
        return messageSet;
    }
}

