/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.instrumentation.external;

import com.atlassian.jira.config.database.DatabaseConfigurationLoader;
import com.atlassian.jira.instrumentation.external.ClassLoadingExternalGauges;
import com.atlassian.jira.instrumentation.external.DatabaseExternalGauges;
import com.atlassian.jira.instrumentation.external.DomainObjectsExternalGauges;
import com.atlassian.jira.instrumentation.external.GarbageCollectionsExternalOp;
import com.atlassian.jira.instrumentation.external.MemoryExternalGauges;
import com.atlassian.jira.instrumentation.external.ThreadExternalGauges;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;

public class ExternalGauges {
    private final DatabaseConfigurationLoader databaseConfigurationLoader;
    private final VelocityRequestContextFactory velocityRequestContextFactory;

    public ExternalGauges(VelocityRequestContextFactory velocityRequestContextFactory, DatabaseConfigurationLoader databaseConfigurationLoader) {
        this.databaseConfigurationLoader = databaseConfigurationLoader;
        this.velocityRequestContextFactory = velocityRequestContextFactory;
    }

    public ExternalGauges installInstruments() {
        new ClassLoadingExternalGauges();
        new MemoryExternalGauges();
        new DomainObjectsExternalGauges();
        new ThreadExternalGauges();
        new GarbageCollectionsExternalOp();
        new DatabaseExternalGauges(this.velocityRequestContextFactory, this.databaseConfigurationLoader).installInstruments();
        return this;
    }
}

