/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.attachment;

import com.atlassian.jira.util.cache.WeakInterner;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class Path
implements Serializable,
Comparable<Path> {
    private static final long serialVersionUID = -8932171926020964811L;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String ELLIPSIS = "...";
    private static final Pattern SPLIT_PATTERN = Pattern.compile("/");
    private static final Pattern SLOSH_SPLIT_PATTERN = Pattern.compile("[/|\\\\]");
    private static final WeakInterner<String> INTERNER = WeakInterner.newWeakInterner();
    private final String[] path;
    private String stringRep;

    public Path() {
        this.path = EMPTY_STRING_ARRAY;
    }

    public Path(CharSequence path) {
        this.path = Path.canonicalize(Path.split(path));
    }

    public Path(CharSequence path, boolean allowSloshes) {
        this.path = Path.canonicalize(Path.split(path, allowSloshes));
    }

    public Path(Path path) {
        this.path = path.path;
    }

    public Path(Path aParent, String aPath) {
        this.path = Path.canonicalize(Path.join(aParent.path, Path.split(aPath)));
    }

    public Path(Path aParent, Path aPath) {
        this.path = Path.canonicalize(Path.join(aParent.path, aPath.path));
    }

    public Path(Path aParent, String aPath, boolean allowSloshes) {
        this.path = Path.canonicalize(Path.join(aParent.path, Path.split(aPath, allowSloshes)));
    }

    public Path(String aParent, Path aPath) {
        this.path = Path.canonicalize(Path.join(Path.split(aParent), aPath.path));
    }

    private Path(List<String> start) {
        this.path = start.toArray(new String[start.size()]);
    }

    private Path(String[] comp) {
        this.path = Path.canonicalize(comp);
    }

    public Path getParent() {
        if (this.path.length == 0) {
            return this;
        }
        return new Path(Arrays.copyOf(this.path, this.path.length - 1));
    }

    public String getPath() {
        if (this.stringRep == null) {
            this.stringRep = StringUtils.join((Object[])this.path, (char)'/');
        }
        return this.stringRep;
    }

    public String[] getComponents() {
        return this.path;
    }

    public String getName() {
        if (this.path.length == 0) {
            return "";
        }
        return this.path[this.path.length - 1];
    }

    public String toString() {
        return this.getPath();
    }

    public boolean equals(Object o) {
        return this == o || o instanceof Path && Arrays.equals(this.path, ((Path)o).path);
    }

    public int hashCode() {
        int result = 0;
        for (String s : this.path) {
            result += s.hashCode();
        }
        return result;
    }

    private static String[] join(String[] aLeft, String[] aRight) {
        String[] result = new String[aLeft.length + aRight.length];
        System.arraycopy(aLeft, 0, result, 0, aLeft.length);
        System.arraycopy(aRight, 0, result, aLeft.length, aRight.length);
        return result;
    }

    public static String join(String str1, String str2) {
        if (str1 == null || str1.isEmpty()) {
            return str2 == null ? "" : str2;
        }
        if (str2 == null || str2.isEmpty()) {
            return str1;
        }
        StringBuilder sb = new StringBuilder(str1.length() + str2.length() + 1);
        sb.append(str1);
        if (sb.charAt(sb.length() - 1) != '/') {
            sb.append('/');
        }
        int startAt = str2.charAt(0) == '/' ? 1 : 0;
        return sb.append(str2, startAt, str2.length()).toString();
    }

    private static String[] split(CharSequence aPath) {
        return Path.split(aPath, false);
    }

    private static String[] split(CharSequence aPath, boolean allowSloshes) {
        if (aPath == null || aPath.length() == 0) {
            return EMPTY_STRING_ARRAY;
        }
        if (aPath.charAt(0) == '/') {
            if (aPath.length() == 1) {
                return EMPTY_STRING_ARRAY;
            }
            aPath = aPath.subSequence(1, aPath.length());
        }
        Pattern splitPattern = allowSloshes ? SLOSH_SPLIT_PATTERN : SPLIT_PATTERN;
        return splitPattern.split(aPath);
    }

    public boolean isRoot() {
        return this.path.length == 0 || this.path.length == 1 && this.path[0].isEmpty();
    }

    @Override
    public int compareTo(Path o) {
        return o == null ? -1 : Path.compare(this.path, o.path);
    }

    private static int compare(String[] path1, String[] path2) {
        int limit = Math.min(path1.length, path2.length);
        for (int i = 0; i < limit; ++i) {
            int r = path1[i].compareTo(path2[i]);
            if (r == 0) continue;
            return r;
        }
        return path1.length - path2.length;
    }

    public Path abbreviate(int maxLength) {
        String s;
        if (this.path.length <= 2 || this.getPath().length() <= maxLength) {
            return this;
        }
        ArrayList components = Lists.newArrayList((Object[])this.path);
        int insertEllipsesAt = components.size() / 2;
        for (int len = this.getPath().length(); len > maxLength && components.size() > 2; len -= s.length() + 1) {
            int midPoint = components.size() / 2;
            insertEllipsesAt = Math.min(insertEllipsesAt, midPoint);
            s = (String)components.remove(midPoint);
        }
        components.add(insertEllipsesAt, ELLIPSIS);
        return new Path(components);
    }

    public String getPath(boolean caseSensitive) {
        String normalized = caseSensitive ? this.getPath() : this.getPath().toLowerCase(Locale.US);
        return normalized;
    }

    public void toLowerCase() {
        for (int i = 0; i < this.path.length; ++i) {
            this.path[i] = this.path[i].toLowerCase();
        }
    }

    public String getExtension() {
        String file;
        int dot;
        String extn = null;
        if (this.path.length > 0 && (dot = (file = this.path[this.path.length - 1]).lastIndexOf(46)) != -1 && dot != file.length() - 1) {
            extn = file.substring(dot + 1);
        }
        return extn;
    }

    private static String[] canonicalize(String[] components) {
        for (int i = 0; i < components.length; ++i) {
            components[i] = INTERNER.intern(components[i]);
        }
        return components;
    }
}

