/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.attachment.store.strategy.move;

import com.atlassian.fugue.Unit;
import com.atlassian.jira.issue.attachment.AttachmentGetData;
import com.atlassian.jira.issue.attachment.AttachmentKey;
import com.atlassian.jira.issue.attachment.StreamAttachmentStore;
import com.atlassian.jira.issue.attachment.TemporaryAttachmentId;
import com.atlassian.jira.issue.attachment.store.strategy.move.MoveTemporaryAttachmentStrategy;
import com.atlassian.jira.issue.attachment.store.strategy.move.SendToStoreFunctionFactory;
import com.atlassian.util.concurrent.Effect;
import com.atlassian.util.concurrent.Function;
import com.atlassian.util.concurrent.Promise;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class BackgroundResendingMoveStrategy
implements MoveTemporaryAttachmentStrategy {
    private final StreamAttachmentStore primaryStore;
    private final StreamAttachmentStore secondaryStore;
    private final SendToStoreFunctionFactory sendToStoreFunctionFactory;

    public BackgroundResendingMoveStrategy(StreamAttachmentStore primaryStore, StreamAttachmentStore secondaryStore, SendToStoreFunctionFactory sendToStoreFunctionFactory) {
        this.primaryStore = primaryStore;
        this.secondaryStore = secondaryStore;
        this.sendToStoreFunctionFactory = sendToStoreFunctionFactory;
    }

    @Override
    public Promise<Unit> moveTemporaryToAttachment(TemporaryAttachmentId temporaryAttachmentId, AttachmentKey destinationKey) {
        return this.primaryStore.moveTemporaryToAttachment(temporaryAttachmentId, destinationKey).done(this.sendAttachmentToSecondaryStore(destinationKey));
    }

    private Effect<Unit> sendAttachmentToSecondaryStore(final AttachmentKey destinationKey) {
        return new Effect<Unit>(){

            public void apply(Unit unit) {
                BackgroundResendingMoveStrategy.this.primaryStore.getAttachmentData(destinationKey, BackgroundResendingMoveStrategy.this.sendToSecondaryStore(destinationKey));
            }
        };
    }

    private Function<AttachmentGetData, Unit> sendToSecondaryStore(AttachmentKey destinationKey) {
        return this.sendToStoreFunctionFactory.createFunction(destinationKey, this.secondaryStore);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BackgroundResendingMoveStrategy that = (BackgroundResendingMoveStrategy)o;
        return this.primaryStore.equals(that.primaryStore) && this.secondaryStore.equals(that.secondaryStore);
    }

    public int hashCode() {
        int result = this.primaryStore.hashCode();
        result = 31 * result + this.secondaryStore.hashCode();
        return result;
    }
}

