/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.attachment.zip;

import com.atlassian.fugue.Option;
import com.atlassian.jira.issue.attachment.zip.ZipEntryNotFoundException;
import com.atlassian.jira.util.Consumer;
import com.atlassian.jira.util.IOUtil;
import com.atlassian.jira.util.io.InputStreamConsumer;
import io.atlassian.blobstore.client.api.Unit;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;

public class AttachmentZipEntryStreamConsumer
implements InputStreamConsumer<Unit> {
    private final OutputStream outputStream;
    private final Consumer<ZipArchiveEntry> onZipEntryExists;
    private final int entryIndex;

    public AttachmentZipEntryStreamConsumer(OutputStream outputStream, Consumer<ZipArchiveEntry> onZipEntryExists, int entryIndex) {
        this.outputStream = outputStream;
        this.onZipEntryExists = onZipEntryExists;
        this.entryIndex = entryIndex;
    }

    public Unit withInputStream(InputStream inputStream) throws IOException, ZipEntryNotFoundException {
        ZipArchiveInputStream zipArchiveInputStream = new ZipArchiveInputStream(inputStream);
        Option<ZipArchiveEntry> zipEntryOption = this.findZipEntryByIndex(zipArchiveInputStream, this.entryIndex);
        if (zipEntryOption.isEmpty()) {
            throw new ZipEntryNotFoundException("Could not find entry with index: " + this.entryIndex);
        }
        ZipArchiveEntry zipEntry = (ZipArchiveEntry)zipEntryOption.get();
        this.streamZipEntry(zipArchiveInputStream, zipEntry);
        return Unit.UNIT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void streamZipEntry(ZipArchiveInputStream zipArchiveInputStream, ZipArchiveEntry zipEntry) throws IOException {
        BufferedInputStream bufferedZipEntryInputStream = null;
        try {
            this.onZipEntryExists.consume((Object)zipEntry);
            bufferedZipEntryInputStream = new BufferedInputStream((InputStream)zipArchiveInputStream);
            IOUtil.copy((InputStream)bufferedZipEntryInputStream, this.outputStream);
        }
        catch (Throwable throwable) {
            IOUtil.shutdownStream(bufferedZipEntryInputStream);
            throw throwable;
        }
        IOUtil.shutdownStream(bufferedZipEntryInputStream);
    }

    private Option<ZipArchiveEntry> findZipEntryByIndex(ZipArchiveInputStream zipInputStream, int entryIndex) throws IOException {
        ZipArchiveEntry entry = zipInputStream.getNextZipEntry();
        for (int i = 0; entry != null && i < entryIndex; ++i) {
            entry = zipInputStream.getNextZipEntry();
        }
        return Option.option((Object)entry);
    }
}

