/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.converters;

import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.issue.customfields.converters.DateTimeConverter;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import java.sql.Timestamp;
import java.util.Date;

public class DateTimeConverterImpl
implements DateTimeConverter {
    private final DateTimeFormatter dateTimeFormatter;

    public DateTimeConverterImpl(DateTimeFormatter dateTimeFormatter) {
        this.dateTimeFormatter = dateTimeFormatter != null ? dateTimeFormatter.forLoggedInUser().withStyle(DateTimeStyle.COMPLETE) : null;
    }

    public String getString(Date value) {
        if (value == null) {
            return "";
        }
        return this.dateTimeFormatter.format(value);
    }

    public Timestamp getTimestamp(String stringValue) throws FieldValidationException {
        if (stringValue == null) {
            return null;
        }
        try {
            return new Timestamp(this.dateTimeFormatter.parse(stringValue).getTime());
        }
        catch (IllegalArgumentException pe) {
            throw new FieldValidationException("Invalid date / time format.  Expected " + this.dateTimeFormatter.getFormatHint());
        }
    }
}

