/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.AbstractOrderableField;
import com.atlassian.jira.issue.fields.NavigableField;
import com.atlassian.jira.issue.search.handlers.SearchHandlerFactory;
import com.atlassian.jira.issue.search.parameters.lucene.sort.MappedSortComparator;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.collect.CompositeMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.SortField;

public abstract class AbstractOrderableNavigableFieldImpl<V>
extends AbstractOrderableField<V>
implements NavigableField {
    public AbstractOrderableNavigableFieldImpl(String id, String name, VelocityTemplatingEngine templatingEngine, ApplicationProperties applicationProperties, JiraAuthenticationContext authenticationContext, PermissionManager permissionManager, SearchHandlerFactory searchHandlerFactory) {
        super(id, name, templatingEngine, applicationProperties, authenticationContext, permissionManager, searchHandlerFactory);
    }

    protected Map<String, Object> getVelocityParams(I18nHelper isI18nHelper, Map displayParams, Issue issue) {
        HashMap<String, Object> velocityParams = new HashMap<String, Object>();
        velocityParams.put("i18n", isI18nHelper);
        velocityParams.put("displayParams", displayParams);
        velocityParams.put("displayParameters", displayParams);
        if (displayParams != null) {
            velocityParams.put("readOnly", displayParams.get("readonly") == null ? Boolean.FALSE : displayParams.get("readonly"));
            velocityParams.put("textOnly", displayParams.get("textOnly") == null ? Boolean.FALSE : displayParams.get("textOnly"));
            velocityParams.put("excelView", displayParams.get("excel_view") == null ? Boolean.FALSE : displayParams.get("excel_view"));
            velocityParams.put("noLink", displayParams.get("nolink") == null ? Boolean.FALSE : displayParams.get("nolink"));
            velocityParams.put("prefix", displayParams.get("prefix") == null ? "" : displayParams.get("prefix"));
        } else {
            velocityParams.put("readOnly", Boolean.FALSE);
            velocityParams.put("textOnly", Boolean.FALSE);
            velocityParams.put("excelView", Boolean.FALSE);
            velocityParams.put("noLink", Boolean.FALSE);
            velocityParams.put("prefix", "");
        }
        return CompositeMap.of(velocityParams, this.getVelocityParams(issue));
    }

    public FieldComparatorSource getSortComparatorSource() {
        return new MappedSortComparator(this.getSorter());
    }

    public List<SortField> getSortFields(boolean sortOrder) {
        String fieldName = this.getSorter().getDocumentConstant();
        return Collections.singletonList(new SortField(fieldName, this.getSortComparatorSource(), sortOrder));
    }

    public String getColumnCssClass() {
        return this.getId();
    }

    public String getHiddenFieldId() {
        return this.getId();
    }

    public String prettyPrintChangeHistory(String changeHistory) {
        return changeHistory;
    }

    public String prettyPrintChangeHistory(String changeHistory, I18nHelper i18nHelper) {
        return changeHistory;
    }
}

