/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.AbstractProgressBarSystemField;
import com.atlassian.jira.issue.search.LuceneFieldSorter;
import com.atlassian.jira.issue.util.AggregateTimeTrackingBean;
import com.atlassian.jira.issue.util.AggregateTimeTrackingCalculatorFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.JiraAuthenticationContextImpl;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.bean.TimeTrackingGraphBean;
import com.atlassian.jira.web.bean.TimeTrackingGraphBeanFactory;
import java.util.Map;

public class AggregateProgressBarSystemField
extends AbstractProgressBarSystemField {
    private final AggregateTimeTrackingCalculatorFactory calculatorFactory;
    private final TimeTrackingGraphBeanFactory factory;
    private static final String PROGRESS_BAR_NAME = "common.concepts.aggregate.progress.bar";

    public AggregateProgressBarSystemField(VelocityTemplatingEngine templatingEngine, ApplicationProperties applicationProperties, JiraAuthenticationContext authenticationContext, AggregateTimeTrackingCalculatorFactory calculatorFactory, TimeTrackingGraphBeanFactory factory) {
        super("aggregateprogress", PROGRESS_BAR_NAME, PROGRESS_BAR_NAME, templatingEngine, applicationProperties, authenticationContext);
        this.calculatorFactory = calculatorFactory;
        this.factory = factory;
    }

    @Override
    protected AbstractProgressBarSystemField.TimeTrackingParameters getTimeTrackingGraphBeanParameters(Issue issue, I18nHelper helper) {
        AggregateTimeTrackingBean aggregateBean = this.getAggregateBean(issue);
        TimeTrackingGraphBean trackingGraphBean = this.factory.createBean(aggregateBean, TimeTrackingGraphBeanFactory.Style.NORMAL, helper);
        return new AbstractProgressBarSystemField.TimeTrackingParameters(aggregateBean.getTimeSpent(), aggregateBean.getOriginalEstimate(), aggregateBean.getRemainingEstimate(), trackingGraphBean);
    }

    @Override
    protected String getDisplayId() {
        return "apb";
    }

    public LuceneFieldSorter getSorter() {
        return null;
    }

    private AggregateTimeTrackingBean getAggregateBean(Issue issue) {
        String cacheKey;
        Map<String, Object> requestCache = JiraAuthenticationContextImpl.getRequestCache();
        AggregateTimeTrackingBean bean = (AggregateTimeTrackingBean)requestCache.get(cacheKey = "jira.timetracking.aggregate.bean." + issue.getKey());
        if (bean == null) {
            bean = this.calculatorFactory.getCalculator(issue).getAggregates(issue);
            requestCache.put(cacheKey, bean);
        }
        return bean;
    }
}

