/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.config.manager;

import com.atlassian.jira.issue.fields.ConfigurableField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigItemType;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigCleanup;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigManager;
import com.atlassian.jira.issue.fields.config.persistence.FieldConfigPersister;
import com.atlassian.jira.util.dbc.Null;
import java.util.Collection;
import java.util.List;

public class FieldConfigManagerImpl
implements FieldConfigManager {
    private final FieldConfigPersister configPersister;
    private final FieldConfigCleanup fieldConfigCleanup;

    public FieldConfigManagerImpl(FieldConfigPersister configPersister, FieldConfigCleanup fieldConfigCleanup) {
        Null.not("FieldConfigPersister", configPersister);
        Null.not("FieldConfigCleanup", fieldConfigCleanup);
        this.configPersister = configPersister;
        this.fieldConfigCleanup = fieldConfigCleanup;
    }

    public FieldConfig getFieldConfig(Long configId) {
        return configId == null ? null : this.configPersister.getFieldConfig(configId);
    }

    public FieldConfig createFieldConfig(FieldConfig newConfig, List<FieldConfigItemType> configurationItemTypes) {
        return this.configPersister.create(newConfig, configurationItemTypes);
    }

    public FieldConfig createWithDefaultValues(ConfigurableField field) {
        return this.configPersister.createWithDefaultValues(field);
    }

    public FieldConfig updateFieldConfig(FieldConfig newConfig) {
        return this.configPersister.update(newConfig);
    }

    public void removeConfigsForConfigScheme(Long fieldConfigSchemeId) {
        Collection configs = this.configPersister.getConfigsExclusiveToConfigScheme(fieldConfigSchemeId);
        for (FieldConfig fieldConfig : configs) {
            this.removeFieldConfig(fieldConfig);
        }
    }

    void removeFieldConfig(FieldConfig fieldConfig) {
        this.fieldConfigCleanup.removeAdditionalData(fieldConfig);
        this.configPersister.remove(fieldConfig);
    }
}

