/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.renderer.wiki;

import com.atlassian.renderer.DefaultIconManager;
import com.atlassian.renderer.Icon;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;

public class JiraIconManager
extends DefaultIconManager {
    private volatile Map<String, Icon> emoticonsMap;

    protected Map getIconsMap() {
        HashMap<String, Icon> iconsMap = super.getIconsMap();
        if (iconsMap != null) {
            iconsMap = new HashMap<String, Icon>(iconsMap);
            iconsMap.put("attachment", Icon.makeRenderIcon((String)"icons/link_attachment_7.gif", (int)1, (int)7, (int)7));
            iconsMap.remove("external");
        }
        return iconsMap;
    }

    private Map<String, Icon> generateEmoticonsMap() {
        Map<String, Icon> emoticonsMap = super.getEmoticonsMap();
        if (emoticonsMap != null) {
            emoticonsMap = this.addPngIcons(emoticonsMap);
        }
        return emoticonsMap;
    }

    protected Map<String, Icon> getEmoticonsMap() {
        if (this.emoticonsMap == null) {
            this.emoticonsMap = ImmutableMap.copyOf(this.generateEmoticonsMap());
        }
        return this.emoticonsMap;
    }

    private Map<String, Icon> addPngIcons(Map<String, Icon> originalMap) {
        HashMap resultMap = Maps.newHashMap(originalMap);
        String emoticonsPath = "icons/emoticons/";
        resultMap.put(":-)", Icon.makeEmoticon((String)"icons/emoticons/smile.png", (int)16, (int)16));
        resultMap.put(":)", Icon.makeEmoticon((String)"icons/emoticons/smile.png", (int)16, (int)16));
        resultMap.put(":P", Icon.makeEmoticon((String)"icons/emoticons/tongue.png", (int)16, (int)16));
        resultMap.put(":p", Icon.makeEmoticon((String)"icons/emoticons/tongue.png", (int)16, (int)16));
        resultMap.put(";-)", Icon.makeEmoticon((String)"icons/emoticons/wink.png", (int)16, (int)16));
        resultMap.put(";)", Icon.makeEmoticon((String)"icons/emoticons/wink.png", (int)16, (int)16));
        resultMap.put(":D", Icon.makeEmoticon((String)"icons/emoticons/biggrin.png", (int)16, (int)16));
        resultMap.put(":-(", Icon.makeEmoticon((String)"icons/emoticons/sad.png", (int)16, (int)16));
        resultMap.put(":(", Icon.makeEmoticon((String)"icons/emoticons/sad.png", (int)16, (int)16));
        resultMap.put("(y)", Icon.makeEmoticon((String)"icons/emoticons/thumbs_up.png", (int)16, (int)16));
        resultMap.put("(n)", Icon.makeEmoticon((String)"icons/emoticons/thumbs_down.png", (int)16, (int)16));
        resultMap.put("(i)", Icon.makeEmoticon((String)"icons/emoticons/information.png", (int)16, (int)16));
        resultMap.put("(/)", Icon.makeEmoticon((String)"icons/emoticons/check.png", (int)16, (int)16));
        resultMap.put("(x)", Icon.makeEmoticon((String)"icons/emoticons/error.png", (int)16, (int)16));
        resultMap.put("(+)", Icon.makeEmoticon((String)"icons/emoticons/add.png", (int)16, (int)16));
        resultMap.put("(-)", Icon.makeEmoticon((String)"icons/emoticons/forbidden.png", (int)16, (int)16));
        resultMap.put("(!)", Icon.makeEmoticon((String)"icons/emoticons/warning.png", (int)16, (int)16));
        resultMap.put("(?)", Icon.makeEmoticon((String)"icons/emoticons/help_16.png", (int)16, (int)16));
        resultMap.put("(on)", Icon.makeEmoticon((String)"icons/emoticons/lightbulb_on.png", (int)16, (int)16));
        resultMap.put("(off)", Icon.makeEmoticon((String)"icons/emoticons/lightbulb.png", (int)16, (int)16));
        resultMap.put("(*)", Icon.makeEmoticon((String)"icons/emoticons/star_yellow.png", (int)16, (int)16));
        resultMap.put("(*b)", Icon.makeEmoticon((String)"icons/emoticons/star_blue.png", (int)16, (int)16));
        resultMap.put("(*y)", Icon.makeEmoticon((String)"icons/emoticons/star_yellow.png", (int)16, (int)16));
        resultMap.put("(*g)", Icon.makeEmoticon((String)"icons/emoticons/star_green.png", (int)16, (int)16));
        resultMap.put("(*r)", Icon.makeEmoticon((String)"icons/emoticons/star_red.png", (int)16, (int)16));
        return resultMap;
    }
}

