/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.screen.issuetype;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.project.ProjectAction;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.issue.comparator.ProjectNameComparator;
import com.atlassian.jira.issue.fields.screen.FieldScreenScheme;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenScheme;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeEntity;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeManager;
import com.atlassian.jira.issue.fields.screen.issuetype.ProjectIssueTypeScreenSchemeHelper;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultProjectIssueTypeScreenSchemeHelper
implements ProjectIssueTypeScreenSchemeHelper {
    private static final Logger log = LoggerFactory.getLogger(DefaultProjectIssueTypeScreenSchemeHelper.class);
    private final IssueTypeScreenSchemeManager issueTypeScreenSchemeManager;
    private final ProjectService projectService;
    private final JiraAuthenticationContext authenticationContext;
    private final PermissionManager permissionManager;
    private final ProjectFactory projectFactory;

    public DefaultProjectIssueTypeScreenSchemeHelper(ProjectService projectService, JiraAuthenticationContext authenticationContext, IssueTypeScreenSchemeManager issueTypeScreenSchemeManager, PermissionManager permissionManager, ProjectFactory projectFactory) {
        this.issueTypeScreenSchemeManager = issueTypeScreenSchemeManager;
        this.projectService = projectService;
        this.authenticationContext = authenticationContext;
        this.permissionManager = permissionManager;
        this.projectFactory = projectFactory;
    }

    @Override
    public Multimap<FieldScreenScheme, Project> getProjectsForFieldScreenSchemes(Set<FieldScreenScheme> fieldScreenSchemes) {
        HashMap backingMap = Maps.newHashMap();
        SetMultimap fieldScreenSchemeToProjectMapping = Multimaps.newSetMultimap((Map)backingMap, (Supplier)new Supplier<Set<Project>>(){

            public Set<Project> get() {
                return Sets.newTreeSet((Comparator)ProjectNameComparator.COMPARATOR);
            }
        });
        List<Project> projects = this.getAllProjects();
        for (Project project : projects) {
            IssueTypeScreenScheme issueTypeScreenScheme = this.issueTypeScreenSchemeManager.getIssueTypeScreenScheme(project);
            if (issueTypeScreenScheme == null) {
                log.warn("Unable to find IssueTypeScreenScheme for project " + project.getKey());
                continue;
            }
            IssueTypeScreenSchemeEntity defaultEntity = issueTypeScreenScheme.getEntity(null);
            if (defaultEntity == null) {
                log.warn("Unable to find default IssueTypeScreenSchemeEntity for project " + project.getKey());
                continue;
            }
            FieldScreenScheme defaultFieldScreenScheme = defaultEntity.getFieldScreenScheme();
            for (IssueType issueType : project.getIssueTypes()) {
                IssueTypeScreenSchemeEntity issueTypeScreenSchemeEntity = issueTypeScreenScheme.getEntity(issueType.getId());
                FieldScreenScheme fieldScreenScheme = issueTypeScreenSchemeEntity == null ? defaultFieldScreenScheme : issueTypeScreenSchemeEntity.getFieldScreenScheme();
                if (!fieldScreenSchemes.contains(fieldScreenScheme)) continue;
                fieldScreenSchemeToProjectMapping.put((Object)fieldScreenScheme, (Object)project);
            }
        }
        return fieldScreenSchemeToProjectMapping;
    }

    @Override
    public List<Project> getProjectsForFieldScreenScheme(FieldScreenScheme fieldScreenScheme) {
        Multimap<FieldScreenScheme, Project> projectsForFieldScreenSchemes = this.getProjectsForFieldScreenSchemes(Collections.singleton(fieldScreenScheme));
        return Lists.newArrayList((Iterable)projectsForFieldScreenSchemes.get((Object)fieldScreenScheme));
    }

    @Override
    public List<Project> getProjectsForScheme(IssueTypeScreenScheme issueTypeScreenScheme) {
        TreeSet sharedProjects = Sets.newTreeSet((Comparator)ProjectNameComparator.COMPARATOR);
        List projects = this.projectFactory.getProjects(issueTypeScreenScheme.getProjects());
        for (Project project : projects) {
            if (!this.hasEditPermission(this.authenticationContext.getUser(), project)) continue;
            sharedProjects.add(project);
        }
        return Lists.newArrayList((Iterable)sharedProjects);
    }

    boolean hasEditPermission(ApplicationUser user, Project project) {
        return ProjectAction.EDIT_PROJECT_CONFIG.hasPermission(this.permissionManager, user, project);
    }

    private List<Project> getAllProjects() {
        ServiceOutcome projectsForAction = this.projectService.getAllProjectsForAction(this.authenticationContext.getUser(), ProjectAction.EDIT_PROJECT_CONFIG);
        if (projectsForAction.isValid()) {
            return (List)projectsForAction.getReturnedValue();
        }
        return Collections.emptyList();
    }
}

