/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index;

import java.io.IOException;
import org.apache.lucene.search.IndexSearcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexConsistencyUtils {
    private static final Logger log = LoggerFactory.getLogger(IndexConsistencyUtils.class);

    private IndexConsistencyUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isIndexConsistent(String name, int expectedCount, IndexSearcher searcher) throws IOException {
        try {
            int tolerance;
            int delta;
            int actualCount = searcher.getIndexReader().numDocs();
            if (log.isDebugEnabled()) {
                log.debug("isIndexConsistent: " + name + ": expectedCount=" + expectedCount + "; actualCount=" + actualCount);
            }
            if (expectedCount >= 0 && (delta = Math.abs(expectedCount - actualCount)) > (tolerance = Math.max(10, expectedCount / 10))) {
                log.warn("Index consistency check failed for index '" + name + "': expectedCount=" + expectedCount + "; actualCount=" + actualCount);
                boolean bl = false;
                return bl;
            }
        }
        finally {
            searcher.close();
        }
        return true;
    }
}

