/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.link;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.database.DbConnectionManager;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.issue.link.IssueLink;
import com.atlassian.jira.issue.link.IssueLinkCreator;
import com.atlassian.jira.issue.link.IssueLinkManager;
import com.atlassian.jira.issue.link.IssueLinkType;
import com.atlassian.jira.issue.link.IssueLinkTypeManager;
import com.atlassian.jira.issue.link.LinkCollection;
import com.atlassian.jira.issue.link.LinkCollectionImpl;
import com.atlassian.jira.issue.util.IssueUpdateBean;
import com.atlassian.jira.issue.util.IssueUpdater;
import com.atlassian.jira.model.querydsl.QIssueLink;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.CollectionReorderer;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.ImmutableList;
import com.mysema.query.sql.RelationalPath;
import com.mysema.query.types.Predicate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventComponent
public class DefaultIssueLinkManager
implements IssueLinkManager,
Startable {
    private static final Logger log = LoggerFactory.getLogger(DefaultIssueLinkManager.class);
    private final OfBizDelegator delegator;
    private final DbConnectionManager dbConnectionManager;
    private final IssueLinkCreator issueLinkCreator;
    private final IssueLinkTypeManager issueLinkTypeManager;
    private final IssueUpdater issueUpdater;
    private final IssueIndexManager issueIndexManager;
    private final ApplicationProperties applicationProperties;
    private Cache<Long, List<IssueLink>> inwardLinkCache;
    private Cache<Long, List<IssueLink>> outwardLinkCache;

    public DefaultIssueLinkManager(OfBizDelegator genericDelegator, DbConnectionManager dbConnectionManager, IssueLinkCreator issueLinkCreator, IssueLinkTypeManager issueLinkTypeManager, IssueUpdater issueUpdater, IssueIndexManager issueIndexManager, ApplicationProperties applicationProperties, CacheManager cacheManager) {
        this.delegator = genericDelegator;
        this.dbConnectionManager = dbConnectionManager;
        this.issueLinkCreator = issueLinkCreator;
        this.issueLinkTypeManager = issueLinkTypeManager;
        this.issueUpdater = issueUpdater;
        this.issueIndexManager = issueIndexManager;
        this.applicationProperties = applicationProperties;
        this.inwardLinkCache = cacheManager.getCache(DefaultIssueLinkManager.class.getName() + ".inwardLinkCache", (CacheLoader)new InwardLinkCacheLoader(), new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build());
        this.outwardLinkCache = cacheManager.getCache(DefaultIssueLinkManager.class.getName() + ".outwardLinkCache", (CacheLoader)new OutwardLinkCacheLoader(), new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build());
    }

    public void start() throws Exception {
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.clearCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createIssueLink(Long sourceId, Long destinationId, Long issueLinkTypeId, Long sequence, ApplicationUser remoteUser) throws CreateException {
        if (this.getIssueLink(sourceId, destinationId, issueLinkTypeId) != null) {
            return;
        }
        if (!this.validateIssueLinkType(issueLinkTypeId)) {
            String msg = String.format("There is no IssueLinkType with id: %s", issueLinkTypeId);
            log.error(msg);
            throw new CreateException(msg);
        }
        IssueLink issueLink = null;
        try {
            issueLink = this.storeIssueLink(sourceId, destinationId, issueLinkTypeId, sequence);
            IssueLinkType issueLinkType = issueLink.getIssueLinkType();
            if (!issueLinkType.isSystemLinkType()) {
                this.createCreateIssueLinkChangeItems(issueLink, issueLinkType, remoteUser);
            }
        }
        finally {
            if (issueLink != null) {
                this.outwardLinkCache.remove((Object)issueLink.getSourceId());
                this.inwardLinkCache.remove((Object)issueLink.getDestinationId());
                this.reindexLinkedIssues(issueLink);
            }
        }
    }

    protected void reindexLinkedIssues(IssueLink issueLink) {
        try {
            this.issueIndexManager.reIndex(issueLink.getSourceObject());
            this.issueIndexManager.reIndex(issueLink.getDestinationObject());
        }
        catch (IndexException e) {
            throw new RuntimeException(e);
        }
    }

    private List<IssueLink> getIssueLinks(Map<String, ?> key) {
        List<GenericValue> result = this.delegator.findByAnd("IssueLink", key);
        if (result == null) {
            result = Collections.emptyList();
        }
        return this.buildIssueLinks(result);
    }

    private void createCreateIssueLinkChangeItems(IssueLink issueLink, IssueLinkType issueLinkType, ApplicationUser remoteUser) {
        Issue source = issueLink.getSourceObject();
        Issue destination = issueLink.getDestinationObject();
        ChangeItemBean cib = new ChangeItemBean("jira", "Link", null, null, destination.getKey(), "This issue " + issueLinkType.getOutward() + " " + destination.getKey());
        this.createChangeItem(source, cib, remoteUser);
        cib = new ChangeItemBean("jira", "Link", null, null, source.getKey(), "This issue " + issueLinkType.getInward() + " " + source.getKey());
        this.createChangeItem(destination, cib, remoteUser);
    }

    private void createChangeItem(Issue issue, ChangeItemBean changeItemBean, ApplicationUser remoteUser) {
        IssueUpdateBean issueUpdateBean = new IssueUpdateBean(issue, issue, EventType.ISSUE_UPDATED_ID, remoteUser);
        issueUpdateBean.setDispatchEvent(false);
        issueUpdateBean.setChangeItems(Arrays.asList(changeItemBean));
        this.issueUpdater.doUpdate(issueUpdateBean, true);
    }

    public void removeIssueLink(IssueLink issueLink, ApplicationUser remoteUser) {
        this.removeIssueLinkInternal(issueLink, remoteUser, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeIssueLinkInternal(IssueLink issueLink, ApplicationUser remoteUser, boolean createChangeItem) {
        if (issueLink == null) {
            throw new IllegalArgumentException("Link cannot be null");
        }
        try {
            IssueLinkType issueLinkType;
            this.delegator.removeByAnd("IssueLink", (Map)FieldMap.build((String)"id", (Object)issueLink.getId()));
            if (log.isDebugEnabled()) {
                log.debug("Deleted link with id '" + issueLink.getId() + "'.");
            }
            if (createChangeItem && !(issueLinkType = issueLink.getIssueLinkType()).isSystemLinkType()) {
                this.createRemoveIssueLinkChangeItems(issueLink, issueLinkType, remoteUser);
            }
        }
        finally {
            this.outwardLinkCache.remove((Object)issueLink.getSourceId());
            this.inwardLinkCache.remove((Object)issueLink.getDestinationId());
            this.reindexLinkedIssues(issueLink);
        }
    }

    private void createRemoveIssueLinkChangeItems(IssueLink issueLink, IssueLinkType issueLinkType, ApplicationUser remoteUser) {
        Issue source = issueLink.getSourceObject();
        Issue destination = issueLink.getDestinationObject();
        ChangeItemBean cib = new ChangeItemBean("jira", "Link", destination.getKey(), "This issue " + issueLinkType.getOutward() + " " + destination.getKey(), null, null);
        this.createChangeItem(source, cib, remoteUser);
        cib = new ChangeItemBean("jira", "Link", source.getKey(), "This issue " + issueLinkType.getInward() + " " + source.getKey(), null, null);
        this.createChangeItem(destination, cib, remoteUser);
    }

    public int removeIssueLinks(Issue issue, ApplicationUser remoteUser) {
        return this.removeIssueLinks(issue.getGenericValue(), remoteUser);
    }

    public int removeIssueLinks(GenericValue issue, ApplicationUser remoteUser) {
        if (issue == null) {
            return 0;
        }
        return this.removeIssueLinksInternal(issue, remoteUser, true);
    }

    public int removeIssueLinksNoChangeItems(Issue issue) {
        return this.removeIssueLinksInternal(issue.getGenericValue(), null, false);
    }

    private int removeIssueLinksInternal(GenericValue issue, ApplicationUser remoteUser, boolean createChangeItem) {
        List<IssueLink> outwardLinks = this.getOutwardLinks(issue.getLong("id"));
        this.deleteIssueLinksFromIssue(outwardLinks, remoteUser, createChangeItem);
        int totalLinksDeleted = outwardLinks.size();
        if (log.isDebugEnabled()) {
            log.debug("Deleted " + outwardLinks.size() + " outward links from issue " + issue.getString("key"));
        }
        List<IssueLink> inwardLinks = this.getInwardLinks(issue.getLong("id"));
        this.deleteIssueLinksFromIssue(inwardLinks, remoteUser, createChangeItem);
        totalLinksDeleted += inwardLinks.size();
        if (log.isDebugEnabled()) {
            log.debug("Deleted " + inwardLinks.size() + " inward links from issue " + issue.getString("key"));
        }
        return totalLinksDeleted;
    }

    private void deleteIssueLinksFromIssue(List<IssueLink> issueLinks, ApplicationUser remoteUser, boolean createChangeItem) {
        if (issueLinks != null) {
            for (IssueLink issueLink : issueLinks) {
                this.removeIssueLinkInternal(issueLink, remoteUser, createChangeItem);
            }
        }
    }

    public LinkCollection getLinkCollection(GenericValue issue, ApplicationUser remoteUser) {
        TreeSet<IssueLinkType> linkTypes = new TreeSet<IssueLinkType>();
        HashMap<String, List<Issue>> outwardLinkMap = new HashMap<String, List<Issue>>();
        Long issueId = issue.getLong("id");
        List<IssueLink> outwardLinks = this.getOutwardLinks(issueId);
        if (outwardLinks != null) {
            for (IssueLink issueLink : outwardLinks) {
                IssueLinkType issueLinkType = this.issueLinkTypeManager.getIssueLinkType(issueLink.getLinkTypeId());
                if (issueLinkType.isSystemLinkType()) continue;
                linkTypes.add(issueLinkType);
                Issue linkedIssue = issueLink.getDestinationObject();
                this.storeInLinkMap(outwardLinkMap, issueLinkType.getName(), linkedIssue);
            }
        }
        List<IssueLink> inwardLinks = this.getInwardLinks(issueId);
        HashMap<String, List<Issue>> inwardLinkMap = new HashMap<String, List<Issue>>();
        if (inwardLinks != null) {
            for (IssueLink issueLink : inwardLinks) {
                IssueLinkType issueLinkType = this.issueLinkTypeManager.getIssueLinkType(issueLink.getLinkTypeId());
                if (issueLinkType.isSystemLinkType()) continue;
                linkTypes.add(issueLinkType);
                Issue linkedIssue = issueLink.getSourceObject();
                this.storeInLinkMap(inwardLinkMap, issueLinkType.getName(), linkedIssue);
            }
        }
        return new LinkCollectionImpl(issueId, linkTypes, outwardLinkMap, inwardLinkMap, remoteUser, this.applicationProperties);
    }

    public LinkCollection getLinkCollection(Issue issue, ApplicationUser remoteUser) {
        return this._getLinkCollection(issue, remoteUser, false, true);
    }

    public LinkCollection getLinkCollection(Issue issue, ApplicationUser remoteUser, boolean excludeSystemLinks) {
        return this._getLinkCollection(issue, remoteUser, false, excludeSystemLinks);
    }

    public LinkCollection getLinkCollectionOverrideSecurity(Issue issue) {
        return this._getLinkCollection(issue, null, true, true);
    }

    private LinkCollection _getLinkCollection(Issue issue, ApplicationUser remoteUser, boolean overrideSecurity, boolean excludeSystemLinks) {
        TreeSet<IssueLinkType> linkTypes = new TreeSet<IssueLinkType>();
        HashMap<String, List<Issue>> outwardLinkMap = new HashMap<String, List<Issue>>();
        List<IssueLink> outwardLinks = this.getOutwardLinks(issue.getId());
        if (outwardLinks != null) {
            for (IssueLink issueLink : outwardLinks) {
                IssueLinkType issueLinkType = this.issueLinkTypeManager.getIssueLinkType(issueLink.getLinkTypeId(), excludeSystemLinks);
                if (excludeSystemLinks && issueLinkType.isSystemLinkType()) continue;
                linkTypes.add(issueLinkType);
                Issue linkedIssue = issueLink.getDestinationObject();
                this.storeInLinkMap(outwardLinkMap, issueLinkType.getName(), linkedIssue);
            }
        }
        List<IssueLink> inwardLinks = this.getInwardLinks(issue.getId());
        HashMap<String, List<Issue>> inwardLinkMap = new HashMap<String, List<Issue>>();
        if (inwardLinks != null) {
            for (IssueLink issueLink : inwardLinks) {
                IssueLinkType issueLinkType = this.issueLinkTypeManager.getIssueLinkType(issueLink.getLinkTypeId(), excludeSystemLinks);
                if (excludeSystemLinks && issueLinkType.isSystemLinkType()) continue;
                linkTypes.add(issueLinkType);
                Issue linkedIssue = issueLink.getSourceObject();
                this.storeInLinkMap(inwardLinkMap, issueLinkType.getName(), linkedIssue);
            }
        }
        return new LinkCollectionImpl(issue.getId(), linkTypes, outwardLinkMap, inwardLinkMap, remoteUser, overrideSecurity, this.applicationProperties);
    }

    public List<IssueLink> getOutwardLinks(Long sourceId) {
        if (sourceId == null) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf((Collection)((Collection)this.outwardLinkCache.get((Object)sourceId)));
    }

    public List<IssueLink> getInwardLinks(Long destinationId) {
        if (destinationId == null) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf((Collection)((Collection)this.inwardLinkCache.get((Object)destinationId)));
    }

    public void moveIssueLink(List<IssueLink> issueLinks, Long currentSequence, Long sequence) {
        if (currentSequence == null) {
            throw new IllegalArgumentException("Current sequence cannot be null.");
        }
        if (sequence == null) {
            throw new IllegalArgumentException("Sequence cannot be null.");
        }
        int currentIndex = currentSequence.intValue();
        int index = sequence.intValue();
        CollectionReorderer.moveToPosition(issueLinks, currentIndex, index);
        this.resetSequences(issueLinks);
    }

    public void resetSequences(List<IssueLink> issueLinks) {
        this.dbConnectionManager.execute(dbConnection -> {
            dbConnection.setAutoCommit(false);
            long i = 0L;
            for (IssueLink issueLink : issueLinks) {
                dbConnection.update((RelationalPath<?>)QIssueLink.ISSUE_LINK).set(QIssueLink.ISSUE_LINK.sequence, (Object)i).where((Predicate)QIssueLink.ISSUE_LINK.id.eq((Object)issueLink.getId())).execute();
                ++i;
            }
            dbConnection.commit();
            for (IssueLink issueLink : issueLinks) {
                this.outwardLinkCache.remove((Object)issueLink.getSourceId());
                this.inwardLinkCache.remove((Object)issueLink.getDestinationId());
            }
        });
    }

    public IssueLink getIssueLink(Long sourceId, Long destinationId, Long issueLinkTypeId) {
        List<IssueLink> links = this.getIssueLinks((Map<String, ?>)FieldMap.build((String)"source", (Object)sourceId));
        for (IssueLink link : links) {
            if (!link.getDestinationId().equals(destinationId) || !link.getLinkTypeId().equals(issueLinkTypeId)) continue;
            return link;
        }
        return null;
    }

    public Collection<IssueLink> getIssueLinks(Long issueLinkTypeId) {
        return this.getIssueLinks((Map<String, ?>)FieldMap.build((String)"linktype", (Object)issueLinkTypeId));
    }

    public IssueLink getIssueLink(Long issueLinkId) {
        Assertions.notNull((String)"issueLinkId", (Object)issueLinkId);
        GenericValue issueLinkGV = this.delegator.findByPrimaryKey("IssueLink", issueLinkId);
        if (issueLinkGV == null) {
            return null;
        }
        return this.issueLinkCreator.createIssueLink(issueLinkGV);
    }

    public void changeIssueLinkType(IssueLink issueLink, IssueLinkType swapLinkType, ApplicationUser remoteUser) {
        IssueLinkType oldIssueLinkType = issueLink.getIssueLinkType();
        if (!oldIssueLinkType.isSystemLinkType() && swapLinkType.isSystemLinkType()) {
            log.warn("Changing non-system link type to a system link type.");
        } else if (oldIssueLinkType.isSystemLinkType() && !swapLinkType.isSystemLinkType()) {
            log.warn("Changing system link type to a non-system link type.");
        }
        this.updateIssueLinkType(issueLink, swapLinkType);
        this.outwardLinkCache.remove((Object)issueLink.getSourceId());
        this.inwardLinkCache.remove((Object)issueLink.getDestinationId());
        if (!oldIssueLinkType.isSystemLinkType()) {
            this.createRemoveIssueLinkChangeItems(issueLink, oldIssueLinkType, remoteUser);
            this.createCreateIssueLinkChangeItems(issueLink, swapLinkType, remoteUser);
        }
    }

    private void updateIssueLinkType(IssueLink issueLink, IssueLinkType issueLinkType) {
        this.dbConnectionManager.execute(dbConnection -> dbConnection.update((RelationalPath<?>)QIssueLink.ISSUE_LINK).set(QIssueLink.ISSUE_LINK.linktype, (Object)issueLinkType.getId()).where((Predicate)QIssueLink.ISSUE_LINK.id.eq((Object)issueLink.getId())).execute());
    }

    public boolean isLinkingEnabled() {
        return this.applicationProperties.getOption("jira.option.issuelinking");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IssueLink storeIssueLink(Long sourceId, Long destinationId, Long issueLinkTypeId, Long sequence) {
        try {
            FieldMap fields = FieldMap.build((String)"source", (Object)sourceId, (String)"destination", (Object)destinationId, (String)"linktype", (Object)issueLinkTypeId, (String)"sequence", (Object)sequence);
            IssueLink issueLink = this.buildIssueLink(this.delegator.createValue("IssueLink", (Map)fields));
            return issueLink;
        }
        finally {
            this.outwardLinkCache.remove((Object)sourceId);
            this.inwardLinkCache.remove((Object)destinationId);
        }
    }

    private List<IssueLink> buildIssueLinks(Collection<GenericValue> issueLinkGVs) {
        ArrayList<IssueLink> issueLinks = new ArrayList<IssueLink>(issueLinkGVs.size());
        for (GenericValue issueLinkGV : issueLinkGVs) {
            issueLinks.add(this.buildIssueLink(issueLinkGV));
        }
        return issueLinks;
    }

    private IssueLink buildIssueLink(GenericValue issueLinkGV) {
        return this.issueLinkCreator.createIssueLink(issueLinkGV);
    }

    private void storeInLinkMap(Map<String, List<Issue>> linkMap, String linkTypeName, Issue linkedIssue) {
        List<Issue> matchingLinks = linkMap.get(linkTypeName);
        if (matchingLinks == null) {
            matchingLinks = new ArrayList<Issue>();
            linkMap.put(linkTypeName, matchingLinks);
        }
        matchingLinks.add(linkedIssue);
    }

    public void clearCache() {
        this.inwardLinkCache.removeAll();
        this.outwardLinkCache.removeAll();
    }

    private boolean validateIssueLinkType(long linkTypeId) {
        return this.issueLinkTypeManager.getIssueLinkType(Long.valueOf(linkTypeId), false) != null;
    }

    private class OutwardLinkCacheLoader
    implements CacheLoader<Long, List<IssueLink>> {
        private OutwardLinkCacheLoader() {
        }

        public List<IssueLink> load(Long issueId) {
            return DefaultIssueLinkManager.this.getIssueLinks((Map)FieldMap.build((String)"source", (Object)issueId));
        }
    }

    private class InwardLinkCacheLoader
    implements CacheLoader<Long, List<IssueLink>> {
        private InwardLinkCacheLoader() {
        }

        public List<IssueLink> load(Long issueId) {
            return DefaultIssueLinkManager.this.getIssueLinks((Map)FieldMap.build((String)"destination", (Object)issueId));
        }
    }
}

