/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.index.IndexDirectoryFactory;
import com.atlassian.jira.issue.index.IssueSearcherFactory;
import com.atlassian.jira.issue.search.SearchProviderFactory;
import com.atlassian.jira.util.dbc.Assertions;
import org.apache.lucene.search.IndexSearcher;

public class SearchProviderFactoryImpl
implements SearchProviderFactory {
    private final IssueSearcherFactory issueSearcherFactory;

    public SearchProviderFactoryImpl(IssueSearcherFactory issueSearcherFactory) {
        this.issueSearcherFactory = (IssueSearcherFactory)Assertions.notNull((String)"jiraIndexSearchers", (Object)issueSearcherFactory);
    }

    public SearchProviderFactoryImpl() {
        this((IssueSearcherFactory)ComponentAccessor.getComponentOfType(IssueSearcherFactory.class));
    }

    public IndexSearcher getSearcher(String searcherName) {
        if ("issues".equals(searcherName)) {
            return this.issueSearcherFactory.getEntitySearcher(IndexDirectoryFactory.Name.ISSUE);
        }
        if ("comments".equals(searcherName)) {
            return this.issueSearcherFactory.getEntitySearcher(IndexDirectoryFactory.Name.COMMENT);
        }
        if ("changes".equals(searcherName)) {
            return this.issueSearcherFactory.getEntitySearcher(IndexDirectoryFactory.Name.CHANGE_HISTORY);
        }
        if ("worklog".equals(searcherName)) {
            return this.issueSearcherFactory.getEntitySearcher(IndexDirectoryFactory.Name.WORKLOG);
        }
        throw new UnsupportedOperationException("Only issue, comment and change history indexes are catered for currently");
    }
}

