/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.parameters.lucene;

import com.atlassian.jira.user.ApplicationUser;
import java.util.Map;
import org.apache.commons.collections.map.LRUMap;
import org.apache.lucene.search.Filter;

public class CachedWrappedFilterCache {
    private final Map cache = new LRUMap(8);

    public Filter getFilter(ApplicationUser user) {
        return (Filter)this.cache.get(new WFCacheKey(user));
    }

    public void storeFilter(Filter filter, ApplicationUser user) {
        this.cache.put(new WFCacheKey(user), filter);
    }

    private static class WFCacheKey {
        String username;

        public WFCacheKey(ApplicationUser searcher) {
            if (searcher != null) {
                this.username = searcher.getName();
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WFCacheKey that = (WFCacheKey)o;
            return !(this.username != null ? !this.username.equals(that.username) : that.username != null);
        }

        public int hashCode() {
            return this.username != null ? this.username.hashCode() : 0;
        }
    }
}

