/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.transformer;

import com.atlassian.jira.issue.fields.ResolutionSystemField;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.search.searchers.transformer.FieldFlagOperandRegistry;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.query.operand.EmptyOperand;
import com.atlassian.query.operand.FunctionOperand;
import com.atlassian.query.operand.Operand;
import com.atlassian.query.operand.SingleValueOperand;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.map.CaseInsensitiveMap;

public class DefaultFieldFlagOperandRegistry
implements FieldFlagOperandRegistry {
    private static final Map<String, Map<String, Operand>> REGISTRY;

    public Operand getOperandForFlag(String fieldName, String flagValue) {
        Map<String, Operand> fieldFlags = REGISTRY.get(fieldName);
        if (fieldFlags != null) {
            return fieldFlags.get(flagValue);
        }
        return null;
    }

    public Set<String> getFlagForOperand(String fieldName, Operand operand) {
        Map<String, Operand> fieldFlags = REGISTRY.get(fieldName);
        if (fieldFlags != null) {
            LinkedHashSet<String> flags = new LinkedHashSet<String>();
            for (Map.Entry<String, Operand> entry : fieldFlags.entrySet()) {
                if (!entry.getValue().equals(operand)) continue;
                flags.add(entry.getKey());
            }
            if (!flags.isEmpty()) {
                return flags;
            }
        }
        return null;
    }

    static {
        Map issueTypeFlags = MapBuilder.newBuilder().add((Object)"-2", (Object)new FunctionOperand("standardIssueTypes")).add((Object)"-3", (Object)new FunctionOperand("subTaskIssueTypes")).toMap();
        Map versionFlags = MapBuilder.newBuilder().add((Object)"-3", (Object)new FunctionOperand("releasedVersions")).add((Object)"-2", (Object)new FunctionOperand("unreleasedVersions")).add((Object)"-1", (Object)EmptyOperand.EMPTY).toMap();
        Map componentFlags = MapBuilder.newBuilder().add((Object)SystemSearchConstants.forComponent().getEmptySelectFlag(), (Object)EmptyOperand.EMPTY).toMap();
        Map resolutionFlags = MapBuilder.newBuilder().add((Object)ResolutionSystemField.UNRESOLVED_VALUE.toString(), (Object)new SingleValueOperand("Unresolved")).toMap();
        CaseInsensitiveMap tmpRegistry = new CaseInsensitiveMap();
        tmpRegistry.put(SystemSearchConstants.forIssueType().getJqlClauseNames().getPrimaryName(), issueTypeFlags);
        tmpRegistry.put(SystemSearchConstants.forComponent().getJqlClauseNames().getPrimaryName(), componentFlags);
        tmpRegistry.put(SystemSearchConstants.forAffectedVersion().getJqlClauseNames().getPrimaryName(), versionFlags);
        tmpRegistry.put(SystemSearchConstants.forFixForVersion().getJqlClauseNames().getPrimaryName(), versionFlags);
        tmpRegistry.put(SystemSearchConstants.forResolution().getJqlClauseNames().getPrimaryName(), resolutionFlags);
        REGISTRY = Collections.unmodifiableMap(tmpRegistry);
    }
}

