/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.util;

import com.atlassian.jira.issue.search.constants.SimpleFieldSearchConstants;
import com.atlassian.jira.issue.search.searchers.transformer.SimpleNavigatorCollectorVisitor;
import com.atlassian.jira.issue.search.searchers.util.WorkRatioSearcherConfig;
import com.atlassian.jira.issue.search.searchers.util.WorkRatioSearcherInputHelper;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.NonInjectableComponent;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.ClauseVisitor;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operand.Operand;
import com.atlassian.query.operator.Operator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

@NonInjectableComponent
public class DefaultWorkRatioSearcherInputHelper
implements WorkRatioSearcherInputHelper {
    private final SimpleFieldSearchConstants constants;
    private final WorkRatioSearcherConfig config;
    private final JqlOperandResolver operandResolver;

    public DefaultWorkRatioSearcherInputHelper(SimpleFieldSearchConstants constants, JqlOperandResolver operandResolver) {
        this.constants = (SimpleFieldSearchConstants)Assertions.notNull((String)"constants", (Object)constants);
        this.config = new WorkRatioSearcherConfig(constants.getSearcherId());
        this.operandResolver = (JqlOperandResolver)Assertions.notNull((String)"operandResolver", (Object)operandResolver);
    }

    @Override
    public Map<String, String> convertClause(Clause clause, ApplicationUser user) {
        if (clause == null) {
            return null;
        }
        List<TerminalClause> clauseList = this.validateClauseStructure(clause);
        if (clauseList == null) {
            return null;
        }
        String minValue = null;
        String maxValue = null;
        for (TerminalClause terminalClause : clauseList) {
            String ratio;
            Operand operand = terminalClause.getOperand();
            if (this.operandResolver.isEmptyOperand(operand)) {
                return null;
            }
            List list = this.operandResolver.getValues(user, operand, terminalClause);
            if (list == null || list.size() != 1) {
                return null;
            }
            QueryLiteral ratioLiteral = (QueryLiteral)list.get(0);
            if (ratioLiteral.isEmpty()) {
                return null;
            }
            Operator operator = terminalClause.getOperator();
            if (operator == Operator.LESS_THAN_EQUALS) {
                ratio = DefaultWorkRatioSearcherInputHelper.getRatioFromLiteral(ratioLiteral);
                if (ratio != null) {
                    if (maxValue == null) {
                        maxValue = ratio;
                        continue;
                    }
                    return null;
                }
                return null;
            }
            if (operator == Operator.GREATER_THAN_EQUALS) {
                ratio = DefaultWorkRatioSearcherInputHelper.getRatioFromLiteral(ratioLiteral);
                if (ratio != null) {
                    if (minValue == null) {
                        minValue = ratio;
                        continue;
                    }
                    return null;
                }
                return null;
            }
            return null;
        }
        return MapBuilder.newBuilder().addIfValueNotNull((Object)this.config.getMaxField(), maxValue).addIfValueNotNull((Object)this.config.getMinField(), minValue).toMap();
    }

    List<TerminalClause> validateClauseStructure(Clause clause) {
        SimpleNavigatorCollectorVisitor visitor = new SimpleNavigatorCollectorVisitor(this.constants.getJqlClauseNames());
        clause.accept((ClauseVisitor)visitor);
        List clauses = visitor.getClauses();
        if (!visitor.isValid() || clauses.isEmpty()) {
            return null;
        }
        return clauses;
    }

    private static String getRatioFromLiteral(QueryLiteral ratioLiteral) {
        if (ratioLiteral.getLongValue() != null) {
            return ratioLiteral.getLongValue().toString();
        }
        if (StringUtils.isNotBlank((String)ratioLiteral.getStringValue())) {
            return ratioLiteral.getStringValue();
        }
        return null;
    }
}

