/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.tabpanels;

import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.action.IssueActionComparator;
import com.atlassian.jira.issue.changehistory.ChangeHistory;
import com.atlassian.jira.issue.changehistory.ChangeHistoryManager;
import com.atlassian.jira.issue.changehistory.metadata.HistoryMetadataManager;
import com.atlassian.jira.issue.changehistory.metadata.renderer.HistoryMetadataRenderHelper;
import com.atlassian.jira.issue.history.DateTimeFieldChangeLogHelper;
import com.atlassian.jira.issue.tabpanels.ChangeHistoryAction;
import com.atlassian.jira.issue.tabpanels.GenericMessageAction;
import com.atlassian.jira.issue.tabpanels.IssueCreatedAction;
import com.atlassian.jira.plugin.issuetabpanel.AbstractIssueTabPanel;
import com.atlassian.jira.plugin.issuetabpanel.IssueAction;
import com.atlassian.jira.plugin.profile.UserFormatManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraDurationUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ChangeHistoryTabPanel
extends AbstractIssueTabPanel {
    private static final String ALWAYS_SHOW_HEADER = "alwaysShowHeader";
    private final ChangeHistoryManager changeHistoryManager;
    private final AttachmentManager attachmentManager;
    private final JiraDurationUtils jiraDurationUtils;
    private final CustomFieldManager customFieldManager;
    private final DateTimeFormatterFactory dateTimeFormatterFactory;
    private final DateTimeFieldChangeLogHelper changeLogHelper;
    private final UserFormatManager userFormatManager;
    private final I18nHelper i18nHelper;
    private final JiraAuthenticationContext authenticationContext;
    private final AvatarService avatarService;
    private final HistoryMetadataManager historyMetadataManager;
    private final HistoryMetadataRenderHelper historyMetadataRenderHelper;

    public ChangeHistoryTabPanel(ChangeHistoryManager changeHistoryManager, AttachmentManager attachmentManager, JiraDurationUtils jiraDurationUtils, CustomFieldManager customFieldManager, DateTimeFormatterFactory dateTimeFormatterFactory, DateTimeFieldChangeLogHelper changeLogHelper, UserFormatManager userFormatManager, I18nHelper i18nHelper, JiraAuthenticationContext authenticationContext, AvatarService avatarService, HistoryMetadataManager historyMetadataManager, HistoryMetadataRenderHelper historyMetadataRenderHelper) {
        this.changeHistoryManager = changeHistoryManager;
        this.attachmentManager = attachmentManager;
        this.jiraDurationUtils = jiraDurationUtils;
        this.customFieldManager = customFieldManager;
        this.dateTimeFormatterFactory = dateTimeFormatterFactory;
        this.changeLogHelper = changeLogHelper;
        this.userFormatManager = userFormatManager;
        this.i18nHelper = i18nHelper;
        this.authenticationContext = authenticationContext;
        this.avatarService = avatarService;
        this.historyMetadataManager = historyMetadataManager;
        this.historyMetadataRenderHelper = historyMetadataRenderHelper;
    }

    public List<IssueAction> getActions(Issue issue, ApplicationUser remoteUser) {
        boolean alwaysShowHeader = Boolean.valueOf((String)this.descriptor.getParams().get(ALWAYS_SHOW_HEADER));
        List allChangeHistories = this.changeHistoryManager.getChangeHistoriesForUser(issue, remoteUser);
        ArrayList changeHistoryActions = Lists.newArrayListWithCapacity((int)allChangeHistories.size());
        boolean first = true;
        changeHistoryActions.add(new IssueCreatedAction(this.descriptor, this.dateTimeFormatterFactory.formatter().forLoggedInUser(), this.userFormatManager, this.i18nHelper, this.avatarService, this.authenticationContext, issue));
        for (ChangeHistory changeHistoryItem : allChangeHistories) {
            HistoryMetadataManager.HistoryMetadataResult historyMetadata = this.historyMetadataManager.getHistoryMetadata(changeHistoryItem, remoteUser);
            boolean showHeader = first || alwaysShowHeader;
            changeHistoryActions.add(new ChangeHistoryAction(this.descriptor, changeHistoryItem, showHeader, this.attachmentManager, this.jiraDurationUtils, this.customFieldManager, this.dateTimeFormatterFactory.formatter().forLoggedInUser(), issue, this.changeLogHelper, historyMetadata.getHistoryMetadata(), this.historyMetadataRenderHelper));
            first = false;
        }
        if (changeHistoryActions.isEmpty()) {
            GenericMessageAction action = new GenericMessageAction(this.descriptor.getI18nBean().getText("viewissue.nochanges"));
            return Lists.newArrayList((Object[])new IssueAction[]{action});
        }
        Collections.sort(changeHistoryActions, IssueActionComparator.COMPARATOR);
        return changeHistoryActions;
    }

    public boolean showPanel(Issue issue, ApplicationUser remoteUser) {
        return true;
    }
}

