/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.util;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.event.issue.IssueEventBundleFactory;
import com.atlassian.jira.event.issue.IssueEventManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.changehistory.metadata.HistoryMetadataManager;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.issue.history.ChangeLogUtils;
import com.atlassian.jira.issue.util.IssueUpdateBean;
import com.atlassian.jira.issue.util.IssueUpdater;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.transaction.Transaction;
import com.atlassian.jira.transaction.Txn;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.util.UtilDateTime;

public class DefaultIssueUpdater
implements IssueUpdater {
    private final OfBizDelegator ofBizDelegator;
    private final IssueEventManager issueEventManager;
    private final IssueEventBundleFactory issueEventBundleFactory;

    public DefaultIssueUpdater(OfBizDelegator ofBizDelegator, IssueEventManager issueEventManager, IssueEventBundleFactory issueEventBundleFactory) {
        this.ofBizDelegator = ofBizDelegator;
        this.issueEventManager = issueEventManager;
        this.issueEventBundleFactory = issueEventBundleFactory;
    }

    public void doUpdate(IssueUpdateBean iub, boolean generateChangeItems) {
        iub.getChangedIssue().set("updated", (Object)UtilDateTime.nowTimestamp());
        List<ChangeItemBean> changeItems = ChangeLogUtils.generateChangeItems(iub.getOriginalIssue(), iub.getChangedIssue());
        int size = changeItems.size() + (iub.getChangeItems() == null ? 0 : iub.getChangeItems().size());
        ArrayList modifiedFields = Lists.newArrayListWithCapacity((int)size);
        modifiedFields.addAll(changeItems);
        if (iub.getChangeItems() != null) {
            modifiedFields.addAll(iub.getChangeItems());
        }
        if (!modifiedFields.isEmpty() || iub.getComment() != null) {
            this.storeModifiedFields(iub, generateChangeItems, modifiedFields);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeModifiedFields(IssueUpdateBean iub, boolean generateChangeItems, List<ChangeItemBean> modifiedFields) {
        GenericValue updateIssueGV = new GenericValue(iub.getChangedIssue().getDelegator(), iub.getChangedIssue().getModelEntity());
        updateIssueGV.setPKFields(iub.getChangedIssue().getPrimaryKey().getAllFields());
        for (ChangeItemBean modifiedField : modifiedFields) {
            String fieldName = modifiedField.getField();
            if ("issuetype".equals(fieldName)) {
                fieldName = "type";
            }
            if (!updateIssueGV.getModelEntity().isField(fieldName)) continue;
            updateIssueGV.put(fieldName, iub.getChangedIssue().get(fieldName));
        }
        updateIssueGV.put("updated", iub.getChangedIssue().get("updated"));
        Transaction txn = Txn.begin();
        try {
            this.ofBizDelegator.storeAll((List)ImmutableList.of((Object)updateIssueGV));
            ApplicationUser user = iub.getApplicationUser();
            GenericValue changeGroup = ChangeLogUtils.createChangeGroup(user, iub.getOriginalIssue(), iub.getChangedIssue(), (Collection<ChangeItemBean>)iub.getChangeItems(), generateChangeItems);
            if (changeGroup != null && iub.getHistoryMetadata() != null) {
                ((HistoryMetadataManager)ComponentAccessor.getComponent(HistoryMetadataManager.class)).saveHistoryMetadata(changeGroup.getLong("id"), user, iub.getHistoryMetadata());
            }
            txn.commit();
            if ((changeGroup != null || iub.getComment() != null) && iub.isDispatchEvent()) {
                IssueFactory issueFactory = (IssueFactory)ComponentAccessor.getComponentOfType(IssueFactory.class);
                GenericValue updatedIssue = this.ofBizDelegator.findByPrimaryKey("Issue", updateIssueGV.getLong("id"));
                MutableIssue issue = issueFactory.getIssue(updatedIssue);
                this.issueEventManager.dispatchRedundantEvent(iub.getEventTypeId(), (Issue)issueFactory.getIssue(updatedIssue), user, iub.getComment(), iub.getWorklog(), changeGroup, iub.getParams(), iub.isSendMail(), iub.isSubtasksUpdated());
                this.issueEventManager.dispatchEvent(this.issueEventBundleFactory.createIssueUpdateEventBundle((Issue)issue, changeGroup, iub, user));
            }
        }
        finally {
            txn.finallyRollbackIfNotCommitted();
        }
    }
}

